package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 保安员搜索参数
 * @author Ethan
 */
@Data
public class ContractExportDTO {

	private static final long serialVersionUID = 7649752662428917609L;


	@ModelAnnotation(getName="真实姓名",isExport = true,column = "realname",defaultColumn =true,anotherTable =true)
	private String realname;
	@ModelAnnotation(getName="手机",isExport = true,column = "phone",defaultColumn =true,anotherTable =true)
	private String phone;
	/**
	 * 身份证号码
	 */
	@ModelAnnotation(getName="身份证号码",isExport = true,column = "id_number",defaultColumn =true)
	private String idNumber;
	/**
	 * 入职日期
	 */
	@ModelAnnotation(getName="入职日期",column = "entrydate",isExport = true,defaultColumn =true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date entrydate;
	/**
	 * 签订日期
	 */
	@ModelAnnotation(getName="签订日期",column = "signdate",isExport = true,defaultColumn =true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date signdate;

	/**
	 * 开始日期
	 */
	@ModelAnnotation(getName="合同开始日期",column = "htstartdate",isExport = true,defaultColumn =true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date htstartdate;

	/**
	 * 结束日期
	 */
	@ModelAnnotation(getName="合同结束日期",column = "htenddate",isExport = true,defaultColumn =true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date htenddate;
	/**
	 * 合同年限
	 */
	@ModelAnnotation(getName="合同年限",column = "htLife",isExport = true,defaultColumn =true)
	private String htLife;

	/**
	 * 合同编号
	 */
	@ModelAnnotation(getName="合同编号",column = "htbh",isExport = true,defaultColumn =true)
	private String htbh;

	/**
	 * 合同状态 1已签订、2续签、3已解除、 4、未签订
	 */
	@ModelAnnotation(getName="合同状态",column = "htstate",isExport = true,needTranslate = true,dictName = "htstate")
	private String htstate;

	/**
	 * 文化程度
	 */
	@ModelAnnotation(getName="学历",column = "edu",isExport = true,needTranslate = true,dictName = "edu")
	private String edu;
	/**
	 * 年龄
	 */
	@ModelAnnotation(getName="年龄",column = "age",isExport = true)
	private Integer age;


	/**
	 * 职业水平
	 */
	@ModelAnnotation(getName="职业水平",column = "level",isExport = true,anotherTable = true)
	private String level;
	/***
	 * 资格证书号
	 */
	@ModelAnnotation(getName="资格证书号",column = "zgcredential",isExport = true)
	private String zgcredential;
	/***
	 *是否身份认证
	 */
	@ModelAnnotation(getName="是否身份认证",column = "identityAuthState",isExport = true,needTranslate = true,dictName ="identityAuthState" )
	private String identityAuthState;

	/***
	 *是否初始化
	 */
	@ModelAnnotation(getName="是否初始化",column = "init",isExport = true,anotherTable = true)
	private String init;

	/**
	 * 数据区域
	 */
	@ModelAnnotation(getName="数据区域",column = "native_code")
	private Long nativeCode;

	/**
	 * 机构名称
	 */
	@ModelAnnotation(getName="机构名称",column = "userorgname",isExport = true,anotherTable = true)
	private String userorgname;
	/**
	 * 角色名称
	 */
	@ModelAnnotation(getName="角色名称",column = "userrolename",isExport = true,anotherTable = true)
	private String userrolename;

	/**
	 * 性别
	 */
	@ModelAnnotation(getName="性别",column = "gender",isExport = true)
	private String gender;

	/**
	 * 民族
	 */
	@ModelAnnotation(getName="民族",column = "nation",isExport = true)
	private String nation;

	/**
	 * 籍贯
	 */
	@ModelAnnotation(getName="籍贯",column = "native",isExport = true)
	private Integer natives;

	/**
	 * 身高
	 */
	@ModelAnnotation(getName="身高",column = "stature",isExport = true)
	private Integer stature;

	/**
	 * 血型
	 */
	@ModelAnnotation(getName="血型",column = "blood",isExport = true)
	private String blood;

	/**
	 * 工作经验
	 */
	@ModelAnnotation(getName="工作经验",column = "exp",isExport = true)
	private Integer exp;



	/**
	 * 身份证正面
	 */
	@ModelAnnotation(getName="身份证正面",column = "id_card_front")
	private String idCardFront;

	/**
	 * 身份证反面
	 */
	@ModelAnnotation(getName="身份证反面",column = "id_card_reverse")
	private String idCardReverse;

	/**
	 * 居住证
	 */
	@ModelAnnotation(getName="居住证",column = "residence",isExport = true)
	private String residence;

	/**
	 * 身份证地址
	 */
	@ModelAnnotation(getName="身份证地址",column = "id_card_address",isExport = true)
	private String idCardAddress;

	/**
	 * 现居住地址
	 */
	@ModelAnnotation(getName="现居住地址",column = "current_address",isExport = true)
	private String currentAddress;

	/**
	 * 疾病描述
	 */
	@ModelAnnotation(getName="疾病描述",column = "diseases_history",isExport = true)
	private String diseasesHistory;

	/**
	 * 紧急联系人
	 */
	@ModelAnnotation(getName="紧急联系人",column = "emergency_contact_person",isExport = true)
	private String emergencyContactPerson;

	/**
	 * 紧急联系人电话
	 */
	@ModelAnnotation(getName="紧急联系人电话",column = "emergency_contact_phone",isExport = true)
	private String emergencyContactPhone;





	/**
	 * 证书号
	 */
	@ModelAnnotation(getName="证书号",column = "credential",isExport = true)
	private String credential;

	/**
	 * 五险一金（社保）
	 * 1、已缴交;0、未缴交
	 */
	@ModelAnnotation(getName="五险一金",column = "socialSecurity",isExport = true)
	private String socialSecurity;

	/**
	 * 是否购买意外险
	 */
	@ModelAnnotation(getName="是否购买意外险",column = "insured",isExport = true)
	private Boolean insured;

	/**
	 * 驾照水平
	 */
	@ModelAnnotation(getName="驾照水平",column = "driving_level",isExport = true)
	private String drivingLevel;

	/**
	 * 持枪证证号
	 */
	@ModelAnnotation(getName="持枪证证号",column = "arm_number",isExport = true)
	private String armNumber;

	/**
	 * 持枪证有效期
	 */
	@ModelAnnotation(getName="持枪证有效期",column = "arm_start",isExport = true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date armStart;

	/**
	 * 持枪证有效期
	 */
	@ModelAnnotation(getName="持枪证有效期",column = "arm_end",isExport = true)
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date armEnd;

	/**
	 * 持枪证单位
	 */
	@ModelAnnotation(getName="持枪证单位",column = "arm_unit",isExport = true)
	private String armUnit;

	/**
	 * 是否参军
	 */
	@ModelAnnotation(getName="是否参军",column = "enrolled",isExport = true)
	private Boolean enrolled;

	/**
	 * 是否参加过押运
	 */
	@ModelAnnotation(getName="是否参加过押运",column = "escorted",isExport = true)
	private Boolean escorted;

	/**
	 * 是否有持枪证
	 */
	@ModelAnnotation(getName="是否有持枪证",column = "arm_licence",isExport = true)
	private Boolean armLicence;

	/**
	 * 是否合格
	 */
	@ModelAnnotation(getName="是否合格",column = "qualified",isExport = true)
	private Boolean qualified;

	/**
	 * 不合格描述
	 */
	@ModelAnnotation(getName="不合格描述",column = "unqualified",isExport = true)
	private String unqualified;

	/**
	 * 星级
	 */
	@ModelAnnotation(getName="星级",column = "star_level",isExport = true)
	private Integer starLevel;

	/**
	 * 在线状态（是否在线）
	 */
	@ModelAnnotation(getName="在线状态",column = "guard_status",isExport = true)
	private Integer guardStatus;

	/**
	 * 在职状态
	 * 0离职 ;1在职
	 */
	@ModelAnnotation(getName="在职状态",column = "incumbencyStatus",isExport = true)
	private String incumbencyStatus;
	/**
	 * 所在经度
	 */
	@ModelAnnotation(getName="所在经度",column = "longitude",isExport = true)
	private String longitude;

	/**
	 * 所在纬度
	 */
	@ModelAnnotation(getName="所在纬度",column = "latitude",isExport = true)
	private String latitude;



	/**
	 * 政治面貌
	 */
	@ModelAnnotation(getName="政治面貌",column = "politics",isExport = true)
	private String politics;
	/***
	 * 婚姻 2、未婚 1、已婚 3、离异
	 */
	@ModelAnnotation(getName="婚姻",column = "marriage",isExport = true)
	private String marriage;

	/***
	 * 国籍
	 */
	@ModelAnnotation(getName="国籍",column = "nationality",isExport = true)
	private String nationality;
	/**
	 * 培训单位编码
	 */
	@ModelAnnotation(getName="培训单位编码",column = "traincompanyno",isExport = true)
	private String traincompanyno;
	/***
	 * 发证机关编号
	 */
	@ModelAnnotation(getName="发证机关编号",column = "certificatejgno",isExport = true)
	private String certificatejgno;
	/***
	 * 发证机关名称
	 */
	@ModelAnnotation(getName="发证机关名称",column = "certificatejgname",isExport = true)
	private String certificatejgname;
	/***
	 * 发证日期
	 */
	@ModelAnnotation(getName="发证日期",column = "certificatejgtime",isExport = true)
	private String certificatejgtime;

	/***
	 * 培训单位名称
	 */
	@ModelAnnotation(getName="培训单位名称",column = "traincompanyname",isExport = true)
	private String traincompanyname;
	/**
	 * 培训时间
	 */
	@ModelAnnotation(getName="培训时间",column = "traintime",isExport = true)
	private String traintime;


	/**
	 * 所属公司，部门及角色信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompanyPerson relation;
	/***
	 * 保险产品
	 */
	private String product_name;
	/***
	 * 产品公司
	 */
	private String insurance_ame;
	/***
	 * 有效时间
	 */
	private String inception_date;
	/***
	 * 过期时间
	 */
	private String planned_end_date;
	/***
	 * 保费
	 */
	private String gross_premium;
	/***
	 * 投保人名称
	 */
	private String applicant_name;
	/***
	 * 被保险人数量
	 */
	private String ins_count;

	/***
	 * 资格证培训单位编码
	 */
	@ModelAnnotation(getName="资格证培训单位编码",column = "zgtraincompanyno",isExport = true)
	private String zgtraincompanyno;
	/**
	 * 资格证培训单位名称
	 */
	@ModelAnnotation(getName="资格证培训单位名称",column = "zgtraincompanyname",isExport = true)
	private String zgtraincompanyname;

	/***
	 * 资格证培训时间
	 */
	@ModelAnnotation(getName="资格证培训时间",column = "zgtraintime",isExport = true)
	private String zgtraintime;

	/**
	 * 资格证培训起始时间
	 */
	@ModelAnnotation(getName="资格证培训起始时间",column = "zgtrainstarttime",isExport = true)
	private String zgtrainstarttime;

	/**
	 *资格证培训结束时间
	 */
	@ModelAnnotation(getName="资格证培训结束时间",column = "zgtrainendtime",isExport = true)
	private String zgtrainendtime;

	/**
	 * 持枪证培训起始时间
	 */
	@ModelAnnotation(getName="持枪证培训起始时间",column = "armtrainstarttime",isExport = true)
	private String armtrainstarttime;

	/**
	 *持枪证培训结束时间
	 */
	@ModelAnnotation(getName="持枪证培训结束时间",column = "armtrainendtime",isExport = true)
	private String armtrainendtime;

	/**
	 *持枪证枪型代码
	 */
	@ModelAnnotation(getName="持枪证枪型代码",column = "armtype",isExport = true)
	private String armtype;

	/**
	 *持持枪证发证机关编码
	 */
	@ModelAnnotation(getName="持持枪证发证机关编码",column = "armcertificateno",isExport = true)
	private String armcertificateno;



	/**
	 * 资格发证机关编号
	 */
	@ModelAnnotation(getName="资格发证机关编号",column = "zgcertificatejgno",isExport = true)
	private String zgcertificatejgno;
	/***
	 *资格发证机关名称
	 */
	@ModelAnnotation(getName="资格发证机关名称",column = "zgcertificatejgname",isExport = true)
	private String zgcertificatejgname;

	/**
	 * 资格发证日期
	 */
	@ModelAnnotation(getName="资格发证日期",column = "zgcertificatejgtime",isExport = true)
	private String zgcertificatejgtime;
	/**
	 * 是否持枪
	 */
	@ModelAnnotation(getName="是否持枪",column = "sfcq",isExport = true)
	private String sfcq;


	/***
	 * 照片
	 */
	private String photo;







	/**
	 * 持枪培训公司名称
	 */
	@ModelAnnotation(getName="持枪培训公司名称",column = "armtraincompanyname",isExport = true)
	private String armtraincompanyname;

	/**
	 * 持枪培训公司编号
	 */
	@ModelAnnotation(getName="持枪培训公司编号",column = "armtraincompanyno",isExport = true)
	private String armtraincompanyno;

	/**
	 * 持枪培训时间
	 */
	@ModelAnnotation(getName="持枪培训时间",column = "armtraintime",isExport = true)
	private String armtraintime;

	/**
	 *所属行业协会
	 */
	@ModelAnnotation(getName="所属行业协会",column = "industryassociation",isExport = true)
	private String industryassociation;

	/**
	 *指纹卡号
	 */
	@ModelAnnotation(getName="指纹卡号",column = "fingerprintsno",isExport = true)
	private String fingerprintsno;

	/**
	 *持枪证发证机关
	 */
	@ModelAnnotation(getName="持枪证发证机关",column = "armcertificatejgname",isExport = true)
	private String armcertificatejgname;

	/**
	 * 持枪证发证日期
	 */
	@ModelAnnotation(getName="持枪证发证日期",column = "armcertificatejgtime",isExport = true)
	private String armcertificatejgtime;

	/***
	 * 当前时间在线任务数
	 */
	@ModelAnnotation(getName="当前时间在线任务数",column = "lineTask",isExport = true)
	private Integer lineTask;
	/***
	 * 保险订单号
	 */
	@ModelAnnotation(getName="保险订单号",column = "bxOrderno",isExport = true)
	private String bxOrderno;
	/***
	 * 保险额度
	 */
	@ModelAnnotation(getName="保险额度",column = "insuranceAmount",isExport = true)
	private String insuranceAmount;
	/**
	 * 区域
	 */
	@ModelAnnotation(getName="区域",column = "areacode",isExport = true)
	private String areacode;

	/**
	 * 审查状态003审查通过 004审查不通过
	 */
	@ModelAnnotation(getName="审查状态",column = "censor_status")
	private String censorStatus;

	/**
	 * 人员类别   1内勤人员2普通保安员3武装押运人员
	 */
	@ModelAnnotation(getName="人员类别",column = "personType")
	private String personType;







	/**
	 *离职时间
	 */
	@ModelAnnotation(getName="离职时间",column = "leaveDate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date leaveDate ;

	/**
	 * 当前保安员角色
	 */
	@JsonIgnoreProperties(value={"handler"})
	private Role role;

	@JsonIgnoreProperties(value={"handler"})
	private List<Role> roles;

}
