package com.bcxin.ars.dto.exam;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * 考试人员搜索类
 *
 * @author wangjianchi
 */
public class TrainExamPersonSearchDto extends SearchDto<TrainExamPerson> implements Serializable {

	private static final long serialVersionUID = -8959508042727402342L;
	/**
	 * 行政区划编码
	 */
	private String areaCode;

	private Long id;

	/**
	 * 考点ID
	 */
	private Long examID;

	/**
	 * 身份证号
	 */
	private String identitynumber;

	/**
	 * 准考证
	 */
	private String ticket;

	/**
	 * 姓名
	 */
	private String fullname;

	/**
	 * 公司
	 */
	private String company;

	/**
	 * 手机号码
	 */
	private String mobile;

	/**
	 * 笔试成绩
	 */
	private Integer writtenScore;

	/**
	 * 实操成绩
	 */
	private Integer operateScore;

	/**
	 * 总成绩
	 */
	private BigDecimal sumScore;

	/**
	 * 考试状态(0:不合格,1:合格，空值则未录入)
	 */
	private String testState;

	/**
	 * 考试通知状态
	 */
	private String noticeState;

	/**
	 * 成绩通知状态
	 */
	private String scoreMsgState;

	/**
	 * 制证状态
	 */
	private String cardState;

	/**
	 * 性别(1:男，2：女)
	 */
	private String sex;

	/**
	 * 笔试状态(0:未开始,1:已完成)
	 */
	private String writtenState ;

	/**
	 * 笔试考试信息:记录在线考试答题记录
	 */
	private String writtenRecord;

	/**
	 * 保安员证人员ID
	 */
	private Long bbdPersonID;

	/**
	 * 创建人
	 */
	private String createBy;

	/**
	 * 培训机构ID
	 */
	private String organID;

	/**
	 * 培训机构名称
	 */
	private String organName;

	private String prostate;

	/**
	 * 是否有效
	 */
	private Boolean active;

	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 * 更新人
	 */
	private String updateBy;

	private String zsbh;

	private String[] idArrs;

	private String  sendMsg;

	public String getSendMsg() {
		return sendMsg;
	}

	public void setSendMsg(String sendMsg) {
		this.sendMsg = sendMsg;
	}

	public String[] getIdArrs() {
		return idArrs;
	}

	public String getZsbh() {
		return zsbh;
	}

	public void setZsbh(String zsbh) {
		this.zsbh = zsbh;
	}

	public void setIdArrs(String[] idArrs) {
		this.idArrs = idArrs;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public String getProstate() {
		return prostate;
	}

	public void setProstate(String prostate) {
		this.prostate = prostate;
	}

	private Date updateTime;

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getExamID() {
		return examID;
	}

	public void setExamID(Long examID) {
		this.examID = examID;
	}

	public String getIdentitynumber() {
		return identitynumber;
	}

	public void setIdentitynumber(String identitynumber) {
		this.identitynumber = identitynumber;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getFullname() {
		return fullname;
	}

	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public Integer getWrittenScore() {
		return writtenScore;
	}

	public void setWrittenScore(Integer writtenScore) {
		this.writtenScore = writtenScore;
	}

	public Integer getOperateScore() {
		return operateScore;
	}

	public void setOperateScore(Integer operateScore) {
		this.operateScore = operateScore;
	}

	public BigDecimal getSumScore() {
		return sumScore;
	}

	public void setSumScore(BigDecimal sumScore) {
		this.sumScore = sumScore;
	}

	public String getTestState() {
		return testState;
	}

	public void setTestState(String testState) {
		this.testState = testState;
	}

	public String getNoticeState() {
		return noticeState;
	}

	public void setNoticeState(String noticeState) {
		this.noticeState = noticeState;
	}

	public String getScoreMsgState() {
		return scoreMsgState;
	}

	public void setScoreMsgState(String scoreMsgState) {
		this.scoreMsgState = scoreMsgState;
	}

	public String getCardState() {
		return cardState;
	}

	public void setCardState(String cardState) {
		this.cardState = cardState;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getWrittenState() {
		return writtenState;
	}

	public void setWrittenState(String writtenState) {
		this.writtenState = writtenState;
	}

	public String getWrittenRecord() {
		return writtenRecord;
	}

	public void setWrittenRecord(String writtenRecord) {
		this.writtenRecord = writtenRecord;
	}

	public Long getBbdPersonID() {
		return bbdPersonID;
	}

	public void setBbdPersonID(Long bbdPersonID) {
		this.bbdPersonID = bbdPersonID;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getOrganID() {
		return organID;
	}

	public void setOrganID(String organID) {
		this.organID = organID;
	}

	public String getOrganName() {
		return organName;
	}

	public void setOrganName(String organName) {
		this.organName = organName;
	}

}
