package com.bcxin.ars.dto;

import org.springframework.util.StringUtils;

import com.bcxin.ars.model.User;

/**
 * 公安搜索类
 * @author Ethan
 */
public class UserSearchDto extends SearchDto<User> {

	private String realname;
	
	private String codeNo;
	
	private String idNumber;

	private String platform;
	
	private String phone;

	private String orgIds;//组织结构（可多个用,隔开）

	private String[] orgIdList;
	
	private Long orgid;

	private Long userid;

	/**
	 * 是否连下级机构所属的用户查询出来
	 */
	private Boolean includeSub = false;

	@Override
	public Long getUserid() {
		return userid;
	}

	@Override
	public void setUserid(Long userid) {
		this.userid = userid;
	}

	//是否民警
	private Boolean policeman;


	private String username;
	
	
	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getRealname() {
		return realname;
	}

	public void setRealname(String realname) {
		this.realname = realname;
	}

	public String getCodeNo() {
		return codeNo;
	}

	public void setCodeNo(String codeNo) {
		this.codeNo = codeNo;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}
	
	public String getOrgIds() {
		return orgIds;
	}

	public void setOrgIds(String orgIds) {
		this.orgIds = orgIds;
	}
	
	public String[] getOrgIdList() {
		String[] orgs = null;
		if(orgIdList == null || orgIdList.length<1){
			if(!StringUtils.isEmpty(orgIds)){
				orgs = orgIds.split(",");
			}
		}else{
			orgs = orgIdList;
		}
		return orgs;
	}

	public void setOrgIdList(String[] orgIdList) {
		this.orgIdList = orgIdList;
	}

	public Long getOrgid() {
		return orgid;
	}

	public void setOrgid(Long orgid) {
		this.orgid = orgid;
	}

	public Boolean getPoliceman() {
		return policeman;
	}

	public void setPoliceman(Boolean policeman) {
		this.policeman = policeman;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}


	public Boolean getIncludeSub() {
		return includeSub;
	}

	public void setIncludeSub(Boolean includeSub) {
		this.includeSub = includeSub;
	}
}
