package com.abcxin.smart.validator.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;

/**
 * 分布式锁注释类
 * @author sbh
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface RedissonAnnotation {
    /**
     * 锁的名称
     * @return
     */
    String getLockName();
    /***
     * 最多等待秒数
     * @return
     */
    long getWaitTime() default 5;

    /**
     * 上锁以后多少时间自动解锁
     * @return
     */
    long getLeaseTime() default 300;

    /***
     * 单元
     * @return
     */
    TimeUnit getUnit() default TimeUnit.SECONDS;

}
