package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 海外经营信息管理
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "sb_business_outside_management")
public class Hwjyxx extends XxbaBaseDto {

	/**
	 *服务对象名称
	 */
	private String fwdxname;

	/**
	 *保安服务公司编码
	 */
	@MinisterialAttr(column = "(select sc.companyCode from security_company sc where sc.user_id = t1.user_id and sc.active = true)", isSubQuery = true)
	private String bagsbm;

	/**
	 * 保安服务公司名称
	 */
	@MinisterialAttr(column = "(select sc.name from security_company sc where sc.user_id = t1.user_id and sc.active = true)", isSubQuery = true)
	private String bagsmc;

	/**
	 * 备注1
	 */
	private String bz1;

	/**

	 * 备注2
	 */
	private String bz2;

	/**
	 *  备注3
	 */
	private String bz3;

	/**
	 *  合同金额
	 */
	private String htje;

	/**
	 * 人员来源
	 * @return
	 */
	private String ryly;

	/**
	 *涉外经营国别
	 */
	@MinisterialAttr(column = "national", DATA_FORMAT = MinisterialDataFormat.NATIONAL)
	private String gj;

	/**
	 * 经营起始时间
	 */
	private String jyksrq;

	/**
	 * 经营结束时间
	 */
	private String jyjsrq;

	/**

	 * 经营模式
	 */
	private String jyms;

	/**
	 *  备案公安机关名称
	 */
	private String bajgmc;

	/**
	 *  备案日期
	 */
	private String barq;

	/**
	 * 保安服务类型
	 * @return
	 */
	private String fwlx;

}
