package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安监管力量基本信息上报
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "user", extraWhere = "and platform = 1 and ifnull(isAdmin,0) != 1")
public class Bajgll extends XxbaBaseDto {

	/**
	 * 姓名
	 */
	@MinisterialAttr(column = "realname")
	private String xm;

	/**
	 * 性别
	 */
	private String xb;

	/**
	 * 职务
	 */
	private String zw;

	/**
	 * 联系电话
	 */
	@MinisterialAttr(column = "phone")
	private String sj;


	/**
	 * 监管状态
	 */
	@MinisterialAttr(column = "active")
	private String jgzt;

	/**
	 * 证件号码
	 */
	@MinisterialAttr(column = "idnumber")
	private String sfzh;

	/**
	 * 监管机构类型
	 */
	private String jgjglx;

	/**
	 * 省市县（区）
	 */
	private String jgjgdz;

	/**
	 * 办公地址
	 */
	private String jgjgxz;


	/**
	 * 所属公安机关代码
	 */
	@MinisterialAttr(column = "native_code", DATA_FORMAT = MinisterialDataFormat.POLICE_ORG_CODE)
	private String jgjgbh;

	/**
	 * 所属公安机关名称
	 */
	private String jgjgmc;

	/**
	 * 是否专职
	 */
	private String jgmjlx;



	/**
	 * 证件类型
	 */
	private String bz1;

	/**
	 * 备注2
	 */
	private String bz2;

	/**
	 * 备注3
	 */
	private String bz3;

}
