package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * @author zhangyutong
 */
public class YuanDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String yuan = (String) data;
        if (yuan != null) {
            BigDecimal bigDecimal = new BigDecimal(yuan);
            return String.valueOf(bigDecimal.multiply(BigDecimal.valueOf(10000)));
        }
        return null;
    }
}
