package com.bcxin.ars.model.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * 安保任务人员排班
 * @author Ethan
 */
public class TaskPersonSchedule implements Serializable {

	private static final long serialVersionUID = 5336766060968964103L;
	
	private Long id;
	
	/**
	 * 区域编号
	 */
	private Long nativeCode;

	/**
	 * 所属任务中的人员ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long taskPersonId;
	
	/**
	 * 任务日期
	 */
	private String taskDate;
	
	/**
	 * 班次明细
	 */
	private List<SecurityCompanySchedule> scheduleDetail = new ArrayList<SecurityCompanySchedule>();
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getTaskPersonId() {
		return taskPersonId;
	}

	public void setTaskPersonId(Long taskPersonId) {
		this.taskPersonId = taskPersonId;
	}

	public String getTaskDate() {
		return taskDate;
	}

	public void setTaskDate(String taskDate) {
		this.taskDate = taskDate;
	}

	public List<SecurityCompanySchedule> getScheduleDetail() {
		return scheduleDetail;
	}

	public void setScheduleDetail(List<SecurityCompanySchedule> scheduleDetail) {
		this.scheduleDetail = scheduleDetail;
	}
	
}
