package com.bcxin.ars.model.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/***
 * 导出配置字段信息表
 * @author subh
 */
@Data
public class ExportColumn extends BaseModel {
    /**
     * 字段名称
     */
    @ModelAnnotation(isGrid = true,column ="columnName",getName = "字段名称",width = "100px")
    private String columnName;

    /**
     *字段宽度
     */
    @ModelAnnotation(isGrid = true,column ="columnWith",getName = "字段宽度",width = "100px")
    private Integer columnWith;

    /***
     * 占用几列
     */
    @ModelAnnotation(isGrid = true,column ="occupy",getName = "占用几列",width = "80px")
    private Integer occupy;

    /***
     * 起始列
     */
    @ModelAnnotation(isGrid = true,column ="beginCol",getName = "起始列",width = "80px")
    private Integer beginCol;

    /**
     * 字段值来源
     */
    @ModelAnnotation(isGrid = true,column ="columnValueSource",getName = "字段值来源",width = "100px")
    private String columnValueSource;

    /***
     * 字段值公式
     */
    @ModelAnnotation(isGrid = true,column ="formula",getName = "字段值公式",width = "100px",dictName = "exportFormulaType")
    private String formula;

    /***
     * 日期格式
     */
    @ModelAnnotation(isGrid = true,column ="formatDate",getName = "日期格式",width = "100px")
    private String formatDate;

    /***
     * 码表类型
     */
    @ModelAnnotation(isGrid = true,column ="sysCodeType",getName = "码表类型",width = "100px")
    private String sysCodeType;

    /***
     * 固定内容
     */
    @ModelAnnotation(isGrid = true,column ="context",getName = "固定内容",width = "300px")
    private String context;


    /**
     * 必填标识
     */
    @ModelAnnotation(isGrid = true,column ="required",getName = "必填标识",width = "80px")
    private String required;
    /**
     * 位置
     */
    @ModelAnnotation(isGrid = true,column ="position",getName = "位置",width = "80px")
    private String position;
    /**
     * 排序
     */
    @ModelAnnotation(isGrid = true,column ="seq",getName = "排序",width = "80px")
    private Integer seq;
    /**
     * 是否需要查询
     */
    @ModelAnnotation(isGrid = true,column ="isNeedSelect",getName = "是否需要查询",width = "80px")
    private String isNeedSelect;
    /***
     * 配置表ID
     */
    private Long configId;

}
