package com.bcxin.ars.model.sys;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 数据同步配置
 * by llc 2018-09-02
 */
@Data
public class ConfigSyncData  {


	private static final long serialVersionUID = 2220082166930076300L;
	/**
	 * 主键
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long id;

	/**
	 * 是否有效
	 */
	private Boolean active;


	/**
	 * 表名
	 */
	private String tableName;

	/**
	 * java对象名
	 */
	private String javaObjectName;
	/**
	 * java对象地址
	 */
	private String javaObjectUrl;

	/**
	 * java对象名
	 */
	private String fileName;

	/**
	 * 同步表
	 */
	private String syncTableName;

	/**
	 * 插入同步表方法
	 */
	private String insertSyncFun;

	/**
	 * 插入正式表sql
	 */
	private String insertSql;

	/**
	 * 更新正式表sql
	 */
	private String updateSql;

	/**
	 * 删除同步表sql
	 */
	private String deleteSql;

}
