package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class StepSpecialnode {
    /** 主键 */
    private String orgbusno;

    /** 主键，详见附录2.3 */
    private String projid;

    /** 主键，默认为1，用于重报数据的情况。 */
    private Integer dataver;

    /** 主键，特殊环节序号，标识第几次特殊环节 */
    private Integer sn;

    /** 编码规则见附录2.4 */
    private Long bus_region_id;

    /** 编码规则见附录2.4 */
    private String region_id;

    /** 环节名称 */
    private String nodename;

    /** GB/T 19488.2-2008中机构名称。 */
    private String procunitname;

    /** GB/T 19488.2-2008中组织机构代码 */
    private String procunitid;

    /** 处理人标识 */
    private String procerid;

    /** GB/T 19488.2-2008中姓名 */
    private String procername;

    /** 处理人相关备注 */
    private String procerremark;

    /** 环节开始时间 */
    private Date nodestarttime;

    /** （如果没有结束时间，填写开始时间) */
    private Date nodeendtime;

    /** 通知申请人时间 */
    private Date notetime;

    /** 环节处理意见 */
    private String nodeprocadv;

    /** 环节处理地点 */
    private String nodeprocaddr;

    /** 环节处理依据 */
    private String nodeprocaccord;

    /** 1 - 补齐补正。2 - 听证。3 - 公示。4 - 核实。5 - 挂起。6 – 预审补齐补正。7-预审驳回。 */
    private Byte noderesult;

    /** 这里取环节开始时间 */
    private Date nodetime;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /** V3 */
    private String errorcode1;

    /** V3 */
    private String errormsg1;

    /** V3数据状态：0=未交换；1=正确交换；9=异常 */
    private String status1;

    /** V3 */
    private String errorcode2;

    /** V3 */
    private String errormsg2;

    /** V3数据状态：0=未交换；1=正确交换；9=异常(kettle一对一映射) */
    private String status2;

    /**  */
    private String sysmark;

    /**  */
    private Date localtime;

    /**  */
    private String cd_operation;

    /**  */
    private String specialtype;

    /**  */
    private String specialname;

    /**  */
    private String applyusername;

    /**  */
    private String result;

    /**  */
    private String lists;

}