package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class CommForm {
    /** 主键，由业务系统自动产生 */
    private String unid;

    /** 主键，详见附录2.3 */
    private String projid;

    /** 主键，默认值=1，如果有信息变更，则版本号递增 */
    private String dataver;

    /** GB 32100-2015中统一社会信用代码。 */
    private String deptid;

    /** 业务表单的具体中文名称 */
    private String form_name;

    /** 如果业务系统有该字段，则填写 */
    private String form_unid;

    /** 业务表单展示的顺序号，如果只有一个表单则指=1  */
    private String form_sort;

    /** 如材料的表单、办件申报号等，  */
    private String use_unid;

    /** 业务环节发生行政区划，编码规则见附录2.4 */
    private String region_id;

    /** 事项所属行政区划，编码规则见附录2.4 */
    private String itemregionid;

    /** 详见附录2.5证件类型 */
    private Byte use_type;

    /** 补充说明 */
    private String remark;

    /** 由各业务系统产生，时间格式：YYYY-MM-DDHH24:MI:SS  */
    private Date create_time;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private String signstate;

    /**由于存在同一事项多系统办理的情况，需要明确数据来源具体系统  */
    private String sysmark;

    /**  */
    private Date localtime;

    /** 同步类型 */
    private String cd_operation;

    /** 详见附录2.6  */
    private String item_values;

}