package com.bcxin.ars.model.subsidy;

import com.bcxin.ars.model.BaseModel;
import lombok.Data;


/**
 * 线下补贴审批单对象
 *
 * @table sb_subsidy_offline
 * @author lin
 * @date 2020-11-12
 */
@Data
public class SubsidyOffline extends BaseModel{

    private static final long serialVersionUID=1L;

                                
    /**
     * 公安机构id
     */
    private Long orgId;
        
    /**
     * 操作者id
     */
    private Long userId;
        
    /**
     * 补贴审批表附件id
     */
    private Long appAttachmentId;
        
    /**
     * 审批结果附件id
     */
    private Long resultAttachmentId;
        
    /**
     * 审批状态
     */
    private String offApprovalState;
        
    /**
     * 批次数
     */
    private Integer batchNum;
        
    /**
     * 补贴金额
     */
    private String subsidyMoney;
        
    /**
     * 申请机构数
     */
    private Integer comNum;
        
    /**
     * 申请补贴周期
     */
    private String cycle;
        
    /**
     * 补贴审批表附件
     */
    private String approvePath;
        
    /**
     * 审批结果附件
     */
    private String resultPath;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
