package com.bcxin.ars.model.sb;

import java.util.Date;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * 车辆管理
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月18日 下午2:55:13
 * @注意事项 </b>
 * <b>
 */
@Data
public class Vehicle extends BaseModel{

	/**  */
	private static final long serialVersionUID = -6184911282001223097L;

    @ModelAnnotation(getName="用户ID",column = "userid")
	private Long userid;

	/**
	 * 车辆状态 1：已派出 2：未使用
	 */
    @ModelAnnotation(getName="车辆状态",column = "clstate")
	private String clstate;
	/**
	 * 车牌号码
	 */
    @ModelAnnotation(getName="车牌号码",column = "vehiclenum")
    private String vehiclenum;

    /**
     * 车辆来源
     */
    @ModelAnnotation(getName="车辆来源",column = "vehiclesource")
    private String vehiclesource;

    /**
     * 车辆类型
     */
    @ModelAnnotation(getName="车辆类型",column = "vehicletype")
    private String vehicletype;

    /**
     * 车辆品牌
     */
    @ModelAnnotation(getName="车辆品牌",column = "vehiclebrand")
    private String vehiclebrand;

    /**
     * 车辆型号
     */
    @ModelAnnotation(getName="车辆型号",column = "vehiclemodel")
    private String vehiclemodel;

    /**
     * 车辆颜色
     */
    @ModelAnnotation(getName="车辆颜色",column = "vehiclecolor")
    private String vehiclecolor;

    /**
     * 燃料种类
     */
    @ModelAnnotation(getName="燃料种类",column = "fueltype")
    private String fueltype;

    /**
     * 发动机排量
     */
    @ModelAnnotation(getName="发动机排量",column = "displacement")
    private String displacement;

    /**
     * 发动机号
     */
    @ModelAnnotation(getName="发动机号",column = "enginenum")
    private String enginenum;

    /**
     * 车架号
     */
    @ModelAnnotation(getName="车架号",column = "framenum")
    private String framenum;

    /**
     * 初次登记日期
     */
    @ModelAnnotation(getName="初次登记日期",column = "regdate")
    private Date regdate;

    /**
     * 出厂日期
     */
    @ModelAnnotation(getName="出厂日期",column = "productiondate")
    private Date productiondate;

    /**
     * 购买日期
     */
    @ModelAnnotation(getName="购买日期",column = "buydate")
    private Date buydate;

    /**
     * 车辆登记机关
     */
    @ModelAnnotation(getName="车辆登记机关",column = "regorg")
    private String regorg;

    /**
     * 购买金额
     */
    @ModelAnnotation(getName="购买金额",column = "buyaccout")
    private Integer buyaccout;
    /**
     * 负责人
     */
    @ModelAnnotation(getName="负责人",column = "chargeperson")
    private String chargeperson;

    /**
     * 派出时间
     */
    @ModelAnnotation(getName="派出时间",column = "senddate")
    private Date senddate;
    
    /**
     * 归还时间
     */
    @ModelAnnotation(getName="归还时间",column = "returndate")
    private Date returndate;
    
    /**
     * 报废日期
     */
    @ModelAnnotation(getName="报废日期",column = "scrapdate")
    private Date scrapdate;
    
    /**
     * 备注
     */
    @ModelAnnotation(getName="备注",column = "remarks")
    private String remarks;


    /***
     * 公司名称
     */
    private String companyName;
    
	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	public String getVehiclenum() {
        return vehiclenum;
    }

    public void setVehiclenum(String vehiclenum) {
        this.vehiclenum = vehiclenum == null ? null : vehiclenum.trim();
    }

    public String getVehiclesource() {
        return vehiclesource;
    }

    public void setVehiclesource(String vehiclesource) {
        this.vehiclesource = vehiclesource == null ? null : vehiclesource.trim();
    }

    public String getVehicletype() {
        return vehicletype;
    }

    public void setVehicletype(String vehicletype) {
        this.vehicletype = vehicletype == null ? null : vehicletype.trim();
    }

    public String getVehiclebrand() {
        return vehiclebrand;
    }

    public void setVehiclebrand(String vehiclebrand) {
        this.vehiclebrand = vehiclebrand == null ? null : vehiclebrand.trim();
    }

    public String getVehiclemodel() {
        return vehiclemodel;
    }

    public void setVehiclemodel(String vehiclemodel) {
        this.vehiclemodel = vehiclemodel == null ? null : vehiclemodel.trim();
    }

    public String getVehiclecolor() {
        return vehiclecolor;
    }

    public void setVehiclecolor(String vehiclecolor) {
        this.vehiclecolor = vehiclecolor == null ? null : vehiclecolor.trim();
    }

    public String getFueltype() {
        return fueltype;
    }

    public void setFueltype(String fueltype) {
        this.fueltype = fueltype == null ? null : fueltype.trim();
    }

    public String getDisplacement() {
        return displacement;
    }

    public void setDisplacement(String displacement) {
        this.displacement = displacement == null ? null : displacement.trim();
    }

    public String getEnginenum() {
        return enginenum;
    }

    public void setEnginenum(String enginenum) {
        this.enginenum = enginenum == null ? null : enginenum.trim();
    }

    public String getFramenum() {
        return framenum;
    }

    public void setFramenum(String framenum) {
        this.framenum = framenum == null ? null : framenum.trim();
    }

    public Date getRegdate() {
        return regdate;
    }

    public void setRegdate(Date regdate) {
        this.regdate = regdate;
    }

    public Date getProductiondate() {
        return productiondate;
    }

    public void setProductiondate(Date productiondate) {
        this.productiondate = productiondate;
    }

    public Date getBuydate() {
        return buydate;
    }

    public void setBuydate(Date buydate) {
        this.buydate = buydate;
    }

    public String getRegorg() {
        return regorg;
    }

    public void setRegorg(String regorg) {
        this.regorg = regorg == null ? null : regorg.trim();
    }

	public Integer getBuyaccout() {
		return buyaccout;
	}

	public void setBuyaccout(Integer buyaccout) {
		this.buyaccout = buyaccout;
	}

    public String getChargeperson() {
        return chargeperson;
    }

    public void setChargeperson(String chargeperson) {
        this.chargeperson = chargeperson == null ? null : chargeperson.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

	public String getClstate() {
		return clstate;
	}

	public void setClstate(String clstate) {
		this.clstate = clstate;
	}
	
	public Date getSenddate() {
		return senddate;
	}

	public void setSenddate(Date senddate) {
		this.senddate = senddate;
	}

	public Date getReturndate() {
		return returndate;
	}

	public void setReturndate(Date returndate) {
		this.returndate = returndate;
	}

	public Date getScrapdate() {
		return scrapdate;
	}

	public void setScrapdate(Date scrapdate) {
		this.scrapdate = scrapdate;
	}

}