package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityScope;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * sb_legalchange
 * 法人变更
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
public class Legalchange extends BusinessCommon {

    /**  */
	private static final long serialVersionUID = -2892981931790662070L;


    /**
     * 安保范围
     */
    @JsonManagedReference
    @JsonIgnoreProperties(value = {"handler"})
    private List<SecurityScope> securityScope = new ArrayList<SecurityScope>();

    public List<SecurityScope> getSecurityScope() {
        return securityScope;
    }

    public void setSecurityScope(List<SecurityScope> securityScope) {
        this.securityScope = securityScope;
    }

    private SecurityCompany securityCompany;

    public SecurityCompany getSecurityCompany() {
        return securityCompany;
    }

    public void setSecurityCompany(SecurityCompany securityCompany) {
        this.securityCompany = securityCompany;
    }

    /**
     * 原服务范围
     */
    @ModelAnnotation(getName="原服务范围",isExport = true,column  = "oldsecurityScopes")
    private String oldsecurityScopes;

    /**
     * 变更后服务范围
     */
    @ModelAnnotation(getName="变更后服务范围",isExport = true,column  = "securityScopes")
    private String securityScopes;

    public String getSecurityScopes() {
        return securityScopes;
    }

    public void setSecurityScopes(String securityScopes) {
        this.securityScopes = securityScopes;
    }

    /**
	 * 原公司名称
	 */
    @ModelAnnotation(getName="公司名称",isExport = true,column  = "oldcompanyname",defaultColumn = true)
	private String oldcompanyname;
    /**
     * 变更项目
     *
     */
    @ModelAnnotation(getName="变更项目",isExport = true,column  = "changeProject",defaultColumn = true,needTranslate = true,specialTranslateType = "3",dictName = "changeProject")
    private String changeProject;

	/**
	 * 原办公地址
	 */
    @ModelAnnotation(getName="原办公地址",isExport = true,column  = "oldaddress")
    private String oldaddress;

	/**
	 * 变更后办公地址
	 */
    @ModelAnnotation(getName="变更后办公地址",isExport = true,column  = "address")
    private String address;

	/**
	 * 许可证
	 */
    @ModelAnnotation(getName="许可证",isExport = true,column  = "licencenum")
    private String licencenum;

	/**
	 * 法人姓名
	 */
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true)
    private String legalname;

	/**
	 * 法人性别
	 */
    @ModelAnnotation(getName="法人性别",isExport = true,column  = "legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

	/**
	 * 任职时间
	 */
    @ModelAnnotation(getName="任职时间",isExport = true,column  = "officetime")
    private Date officetime;

	/**
	 * 证件类型
	 */
    @ModelAnnotation(getName="证件类型",isExport = true,column  = "legalcardtype",needTranslate = true,dictName = "idCardType")
    private String legalcardtype;

	/**
	 * 法人证件号码
	 */
    @ModelAnnotation(getName="法人证件号码",isExport = true,column  = "legalcardnumber")
    private String legalcardnumber;

	/**
	 * 拟定法人名称
	 */
    @ModelAnnotation(getName="拟定法人名称",isExport = true,column  = "ndlegalname")
    private String ndlegalname;

	/**
	 * 拟定法人性别
	 */
    @ModelAnnotation(getName="拟定法人性别",isExport = true,column  = "ndlegalsex",needTranslate = true,dictName = "sex")
    private String ndlegalsex;

	/**
	 * 拟定出生年月
	 */
    @ModelAnnotation(getName="拟定出生年月",isExport = true,column  = "ndlegalbrith")
    private Date ndlegalbrith;

	/**
	 * 拟定法人文化程度
	 */
    @ModelAnnotation(getName="拟定法人文化程度",isExport = true,column  = "ndlegalculture",needTranslate = true,dictName = "sex")
    private String ndlegalculture;

	/**
	 * 拟定法人证件类型
	 */
    @ModelAnnotation(getName="拟定法人证件类型",isExport = true,column  = "ndlegalcardtype",needTranslate = true,dictName = "idCardType")
    private String ndlegalcardtype;

	/**
	 * 拟定法人证件号码
	 */
    @ModelAnnotation(getName="拟定法人证件号码",isExport = true,column  = "ndlegalcardnum")
    private String ndlegalcardnum;

	/**
	 * 拟定法人国籍
	 */
    @ModelAnnotation(getName="拟定法人国籍",isExport = true,column  = "ndlegalnationality")
    private String ndlegalnationality;

	/**
	 * 拟定法人手机号码
	 */
    @ModelAnnotation(getName="拟定法人手机号码",isExport = true,column  = "ndlegalphone")
    private String ndlegalphone;

	/**
	 * 拟定法人户籍所在地
	 */
    @ModelAnnotation(getName="拟定法人户籍所在地",isExport = true,column  = "ndlegaladdress")
    private String ndlegaladdress;

	/**
	 * 拟定法人实际地址
	 */
    @ModelAnnotation(getName="拟定法人实际地址",isExport = true,column  = "ndleaglsjaddress")
    private String ndleaglsjaddress;

    /**
     * 原法定代表人审查状态
     */
    @ModelAnnotation(getName="原法定代表人审查状态",isExport = true,column  = "legalcensorstatus")
    private String legalcensorstatus;

    /**
     *拟定法定代表人审查状态
     */
    @ModelAnnotation(getName="拟定法定代表人审查状态",isExport = true,column  = "ndlegalcensorstatus")
    private String ndlegalcensorstatus;

    /**
     *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
     */
    @ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
    private String chargecensorstatus;

    /**
     * 原注册资本
     */
    @ModelAnnotation(getName="原注册资本",isExport = true,column  = "oldregisteredMoney")
    private String oldregisteredMoney;

    /**
     * 变更注册资本
     */
    @ModelAnnotation(getName="变更注册资本",isExport = true,column  = "bgregisteredMoney")
    private Double bgregisteredMoney;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",isExport = true,column  = "otherSecScopeType")
    private String otherSecScopeType;


    @ModelAnnotation(getName="制证状态",isExport = true,column  = "cardState",needTranslate = true,dictName = "cardState")
    private String cardState;

    /***
     * 机构类型
     */
    private String institutionType;


    /***
     * 原发证日期
     */
    private String giveLicenseDate;

    /***
     * 到期换证备注
     */
    private String expireRemarks;

    //批准文号
    private String pzwh;

    //许可证号
    private String xkzh;

    //公司名称
    private String gsmc;

    //法人姓名
    private String frmc;


    //打印状态
    private String hasprint;

    //打印次数
    private String printcount;


    //打印时间
    private String printTime;

    //所属区域
    private String areacode;

    //所属区域
    private String fzrq;

    //正本PDF下载
    private String pdfpath;
    //副本PDF下载
    private String pdfpathRevese;

    //证书类型
    private String certificateType;

    //社会统一信用代码
    private String socialCode;

    public String getCode() {
        return socialCode;
    }

    public void setSocialCode(String socialCode) {
        this.socialCode = socialCode;
    }

    public String getCertificateType() {
        return certificateType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public String getPdfpath() {
        return pdfpath;
    }

    public void setPdfpath(String pdfpath) {
        this.pdfpath = pdfpath;
    }

    public String getPdfpathRevese() {
        return pdfpathRevese;
    }

    public void setPdfpathRevese(String pdfpathRevese) {
        this.pdfpathRevese = pdfpathRevese;
    }

    public String getCardState() {
        return cardState;
    }

    public void setCardState(String cardState) {
        this.cardState = cardState;
    }

    public String getPzwh() {
        return pzwh;
    }

    public void setPzwh(String pzwh) {
        this.pzwh = pzwh;
    }

    public String getXkzh() {
        return xkzh;
    }

    public void setXkzh(String xkzh) {
        this.xkzh = xkzh;
    }

    public String getGsmc() {
        return gsmc;
    }

    public void setGsmc(String gsmc) {
        this.gsmc = gsmc;
    }

    public String getFrmc() {
        return frmc;
    }

    public void setFrmc(String frmc) {
        this.frmc = frmc;
    }

    public String getHasprint() {
        return hasprint;
    }

    public void setHasprint(String hasprint) {
        this.hasprint = hasprint;
    }

    public String getPrintcount() {
        return printcount;
    }

    public void setPrintcount(String printcount) {
        this.printcount = printcount;
    }

    public String getPrintTime() {
        return printTime;
    }

    public void setPrintTime(String printTime) {
        this.printTime = printTime;
    }

    public String getAreacode() {
        return areacode;
    }

    public void setAreacode(String areacode) {
        this.areacode = areacode;
    }

    public String getFzrq() {
        return fzrq;
    }

    public void setFzrq(String fzrq) {
        this.fzrq = fzrq;
    }

    public String getInstitutionType() {
        return institutionType;
    }

    public void setInstitutionType(String institutionType) {
        this.institutionType = institutionType;
    }

    public String getOtherSecScopeType() {
        return otherSecScopeType;
    }

    public void setOtherSecScopeType(String otherSecScopeType) {
        this.otherSecScopeType = otherSecScopeType;
    }

    public Double getBgregisteredMoney() {
        return bgregisteredMoney;
    }

    public void setBgregisteredMoney(Double bgregisteredMoney) {
        this.bgregisteredMoney = bgregisteredMoney;
    }

    public String getLegalcensorstatus() {
        return legalcensorstatus;
    }

    public void setLegalcensorstatus(String legalcensorstatus) {
        this.legalcensorstatus = legalcensorstatus;
    }

    public String getNdlegalcensorstatus() {
        return ndlegalcensorstatus;
    }

    public void setNdlegalcensorstatus(String ndlegalcensorstatus) {
        this.ndlegalcensorstatus = ndlegalcensorstatus;
    }

    public String getChargecensorstatus() {
        return chargecensorstatus;
    }

    public void setChargecensorstatus(String chargecensorstatus) {
        this.chargecensorstatus = chargecensorstatus;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getLicencenum() {
        return licencenum;
    }

    public void setLicencenum(String licencenum) {
        this.licencenum = licencenum == null ? null : licencenum.trim();
    }

    public String getLegalname() {
        return legalname;
    }

    public void setLegalname(String legalname) {
        this.legalname = legalname == null ? null : legalname.trim();
    }

    public String getLegalsex() {
        return legalsex;
    }

    public void setLegalsex(String legalsex) {
        this.legalsex = legalsex == null ? null : legalsex.trim();
    }

    public Date getOfficetime() {
        return officetime;
    }

    public void setOfficetime(Date officetime) {
        this.officetime = officetime;
    }

    public String getLegalcardtype() {
        return legalcardtype;
    }

    public void setLegalcardtype(String legalcardtype) {
        this.legalcardtype = legalcardtype == null ? null : legalcardtype.trim();
    }

    public String getLegalcardnumber() {
        return legalcardnumber;
    }

    public void setLegalcardnumber(String legalcardnumber) {
        this.legalcardnumber = legalcardnumber == null ? null : legalcardnumber.trim();
    }

    public String getNdlegalname() {
        return ndlegalname;
    }

    public void setNdlegalname(String ndlegalname) {
        this.ndlegalname = ndlegalname == null ? null : ndlegalname.trim();
    }

    public String getNdlegalsex() {
        return ndlegalsex;
    }

    public void setNdlegalsex(String ndlegalsex) {
        this.ndlegalsex = ndlegalsex == null ? null : ndlegalsex.trim();
    }

    public Date getNdlegalbrith() {
        return ndlegalbrith;
    }

    public void setNdlegalbrith(Date ndlegalbrith) {
        this.ndlegalbrith = ndlegalbrith;
    }

    public String getNdlegalculture() {
        return ndlegalculture;
    }

    public void setNdlegalculture(String ndlegalculture) {
        this.ndlegalculture = ndlegalculture == null ? null : ndlegalculture.trim();
    }

    public String getNdlegalcardtype() {
        return ndlegalcardtype;
    }

    public void setNdlegalcardtype(String ndlegalcardtype) {
        this.ndlegalcardtype = ndlegalcardtype == null ? null : ndlegalcardtype.trim();
    }

    public String getNdlegalcardnum() {
        return ndlegalcardnum;
    }

    public void setNdlegalcardnum(String ndlegalcardnum) {
        this.ndlegalcardnum = ndlegalcardnum == null ? null : ndlegalcardnum.trim();
    }

    public String getNdlegalnationality() {
        return ndlegalnationality;
    }

    public void setNdlegalnationality(String ndlegalnationality) {
        this.ndlegalnationality = ndlegalnationality == null ? null : ndlegalnationality.trim();
    }

    public String getNdlegalphone() {
        return ndlegalphone;
    }

    public void setNdlegalphone(String ndlegalphone) {
        this.ndlegalphone = ndlegalphone == null ? null : ndlegalphone.trim();
    }

    public String getNdlegaladdress() {
        return ndlegaladdress;
    }

    public void setNdlegaladdress(String ndlegaladdress) {
        this.ndlegaladdress = ndlegaladdress == null ? null : ndlegaladdress.trim();
    }

    public String getNdleaglsjaddress() {
        return ndleaglsjaddress;
    }

    public void setNdleaglsjaddress(String ndleaglsjaddress) {
        this.ndleaglsjaddress = ndleaglsjaddress == null ? null : ndleaglsjaddress.trim();
    }

    public String getOldsecurityScopes() {
        return oldsecurityScopes;
    }

    public void setOldsecurityScopes(String oldsecurityScopes) {
        this.oldsecurityScopes = oldsecurityScopes;
    }

    public String getOldcompanyname() {
        return oldcompanyname;
    }

    public void setOldcompanyname(String oldcompanyname) {
        this.oldcompanyname = oldcompanyname;
    }

    public String getOldaddress() {
        return oldaddress;
    }

    public void setOldaddress(String oldaddress) {
        this.oldaddress = oldaddress;
    }

    public String getOldregisteredMoney() {
        return oldregisteredMoney;
    }

    public void setOldregisteredMoney(String oldregisteredMoney) {
        this.oldregisteredMoney = oldregisteredMoney;
    }

    public String getChangeProject() {
        return changeProject;
    }

    public void setChangeProject(String changeProject) {
        this.changeProject = changeProject;
    }
}