package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 等级证班级
 */
@Data
public class GradeClass extends BaseModel {


    /**
     * 申请时间
     */
    @ModelAnnotation(getName = "申请时间", isExport = true, column = "create_time", isGrid = true, width = "130px")
    private Date createTime;

    /**
     * 班级名称
     */
    @NotBlank(message = "班级名称不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "班级名称", isExport = true, column = "name", sign = SignType.LIKE, isGrid = true, width = "200px")
    private String name;

    /**
     * 培训机构id
     */
    @NotNull(message = "培训机构id不能为空", groups = {ThirdPartyTrain.class})
    private Long trainId;

    /**
     * 培训机构
     */
    @NotBlank(message = "培训机构不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训机构", isExport = true, column = "trainName", sign = SignType.LIKE, isGrid = true, width = "200px")
    private String trainName;

    /**
     * 班级人数
     */
    @ModelAnnotation(getName = "班级人数", isExport = true, column = "perNum", isGrid = true, formatter = "formatPerNumFn", width = "80px")
    private Integer perNum;

    /**
     * 开班开始时间
     */
    //@ModelAnnotation(getName="开班开始时间",isExport = true,column  = "startTime",isGrid=true,width = "130px")
    @Deprecated
    private Date startTime;

    /**
     * 开班结束时间
     */
    //@ModelAnnotation(getName="开班结束时间",isExport = true,column  = "endTime",isGrid=true,width = "130px")
    @Deprecated
    private Date endTime;

    /**
     * 实操培训开班开始时间
     */
    @ModelAnnotation(getName = "实操培训开班开始时间", isExport = true, column = "practiceStartDate", isGrid = true, width = "130px")
    private Date practiceStartDate;

    /**
     * 实操培训开班结束时间
     */
    @ModelAnnotation(getName = "实操培训开班结束时间", isExport = true, column = "practiceEndDate", isGrid = true, width = "130px")
    private Date practiceEndDate;


    /**
     * 审批状态
     */
    @ModelAnnotation(getName = "审批状态", isExport = true, column = "approvalState", width = "80px", needTranslate = true, dictName = "appprovalStateGradeClass", isGrid = true)
    private String approvalState;

    /**
     * 实操培训地点
     */
    @ModelAnnotation(getName = "实操培训地点", isExport = true, column = "address", isGrid = true, width = "180px")
    private String address;

    /***
     * 考场联系人
     */
    @ModelAnnotation(getName = "考场联系人", isExport = true, column = "contactPerson")
    private String contactPerson;

    /***
     * 考场联系人电话
     */
    @ModelAnnotation(getName = "考场联系人电话", isExport = true, column = "contactPersonTel")
    private String contactPersonTel;

    /***
     * 其它联系方式
     */
    @ModelAnnotation(getName = "其它联系方式", isExport = true, column = "otherTel")
    private String otherTel;
    /***
     * 考场联系人邮箱
     */
    @ModelAnnotation(getName = "考场联系人邮箱", isExport = true, column = "contactPersonEmail")
    private String contactPersonEmail;

    /***
     * 注意事项
     */
    @ModelAnnotation(getName = "注意事项", isExport = true, column = "carefulMatter")
    private String carefulMatter;

    /***
     * 结业理论考试开始时间
     */
    @ModelAnnotation(getName = "结业理论考试开始时间", isExport = true, column = "graduationStartTime")
    private Date graduationStartTime;
    /***
     * 结业理论考试结束时间
     */
    @ModelAnnotation(getName = "结业理论考试结束时间", isExport = true, column = "graduationEndTime")
    private Date graduationEndTime;
    /***
     * 结业理论考试地点
     */
    @ModelAnnotation(getName = "结业理论考试地点", isExport = true, column = "graduationStartAddress")
    private String graduationStartAddress;


    /***
     * 结业理论成绩合格
     */
    @ModelAnnotation(getName = "结业理论成绩合格", isExport = true, column = "graduationQualified")
    private String graduationQualified;
    /***
     * 考试方式
     */
    @ModelAnnotation(getName = "结业考试方式", isExport = true, column = "graduationStartExamType")
    private String graduationStartExamType;
    /***
     * 考试试卷
     */
    @ModelAnnotation(getName = "结业考试试卷", isExport = true, column = "graduationStartExamPaper")
    private String graduationStartExamPaper;
    /**
     * 实操考试开始时间
     */
    @ModelAnnotation(getName = "结业实操考试开始时间", isExport = true, column = "graduationOperationStartTime")
    private Date graduationOperationStartTime;
    /**
     * 实操考试结束时间
     */
    @ModelAnnotation(getName = "结业实操考试结束时间", isExport = true, column = "graduationOperationEndTime")
    private Date graduationOperationEndTime;
    /**
     * 实操考试地点
     */
    @ModelAnnotation(getName = "结业实操考试地点", isExport = true, column = "graduationOperationAddress")
    private String graduationOperationAddress;
    /***
     * 结业实操成绩合格
     */
    @ModelAnnotation(getName = "结业实操成绩合格", isExport = true, column = "graduationOperationQualified")
    private String graduationOperationQualified;
    /***
     * 鉴定理论考试时间
     */
    @ModelAnnotation(getName = "鉴定理论考试时间", isExport = true, column = "appraisalStartTime")
    private Date appraisalStartTime;
    /***
     * 鉴定理论考试开始时间
     */
    @ModelAnnotation(getName = "鉴定理论考试开始时间", isExport = true, column = "appraisalEndTime")
    private Date appraisalEndTime;
    /***
     * 鉴定理论考试地址
     */
    @ModelAnnotation(getName = "鉴定理论考试地址", isExport = true, column = "appraisalAddress")
    private String appraisalAddress;
    /***
     * 鉴定理论成绩合格
     */
    @ModelAnnotation(getName = "鉴定理论成绩合格", isExport = true, column = "appraisalQualified")
    private String appraisalQualified;
    /**
     * 鉴定实操考试开始时间
     */
    @ModelAnnotation(getName = "鉴定实操考试开始时间", isExport = true, column = "appraisalOperationStartTime")
    private Date appraisalOperationStartTime;
    /**
     * 鉴定实操考试结束时间
     */
    @ModelAnnotation(getName = "鉴定实操考试结束时间", isExport = true, column = "appraisalOperationEndTime")
    private Date appraisalOperationEndTime;
    /**
     * 鉴定实操考试地点
     */
    @ModelAnnotation(getName = "鉴定实操考试地点", isExport = true, column = "appraisalOperationAddress")
    private String appraisalOperationAddress;

    /***
     * 鉴定实操成绩合格
     */
    @ModelAnnotation(getName = "鉴定实操成绩合格", isExport = true, column = "appraisalOperationQualified")
    private String appraisalOperationQualified;
    /***
     * 对外意见
     */
    @ModelAnnotation(getName = "对外意见", isExport = true, column = "approvalReson", isGrid = true, width = "200px")
    private String approvalReson;
    /***
     * 对内意见
     */
    @ModelAnnotation(getName = "对内意见", isExport = true, column = "approvalResonIn", isGrid = true, width = "200px")
    private String approvalResonIn;

    /***
     * 开班开始时间
     */
    @ModelAnnotation(getName = "实操培训开班开始时间", column = "practiceStartDate", sign = SignType.DATE_GREATER_EQUAL)
    private String queryStartTime;

    /***
     * 开班结束时间
     */
    @ModelAnnotation(getName = "实操培训开班结束时间", column = "practiceEndDate", sign = SignType.DATE_LESS_EQUAL)
    private String queryEndTime;

    /**
     * 等级
     */
    @ModelAnnotation(getName = "等级", isExport = true, column = "gradeLevel", needTranslate = true, dictName = "appraisalGrade", isGrid = true, width = "80px")
    private String gradeLevel;

    @ModelAnnotation(getName = "实操培训课程表", column = "practiceScheduleUrl")
    private String practiceScheduleUrl;
    /**
     * 实操培训签到表
     */
    @ModelAnnotation(getName = "实操培训签到表", column = "practiceSignUrl")
    private String practiceSignUrl;

    /**
     * 公安督导检查表
     */
    @ModelAnnotation(getName = "公安督导检查表", column = "policeCheckUrl")
    private String policeCheckUrl;

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}