package com.bcxin.ars.model.certificate;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.ProjectChange;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 保安培训机构
 *
 * @author Ethan
 */
@Data
public class TrainCertificate extends BaseModel {

    private static final long serialVersionUID = 7649752662428917609L;

    /**
     * 批准文号
     */
    private String pzwh;


    /**
     * 培训内容
     */
    private String pxnr;


    /**
     * 许可证号
     */
    @ModelAnnotation(getName = "许可证号",column = "xkzh",isGrid = true,width = "150px")
    private String xkzh;

    /**
     * 公司名称
     */
    @ModelAnnotation(getName = "公司名称",column = "gsmc",isGrid = true,width = "250px")
    private String gsmc;

    /**
     * 法定代表人
     */
    @ModelAnnotation(getName = "法定代表人",column = "frmc",isGrid = true,width = "100px")
    private String frmc;

    /**
     * 注册资本
     */
    private String zczb;

    /**
     * 发证日期
     */
    @ModelAnnotation(getName = "发证日期",column = "fzrq",isGrid = true,width = "80px",formatter = "formatOperationDate")
    private Date fzrq;

    /**
     * 成立
     */
    private Date  clrq;

    /**
     * 申请人
     */
    private String slr;

    /**
     * 申请人手机
     */
    private String slrsj;

    /**
     * 制证日期
     */
    private Date zzrq;

    /**
     * 保安服务公司申报ID
     */
    private Long traincompanyapplyid;

    /**
     * 公司地址
     */
    private String gsdz;

    /**
     * 注册资本类型
     */
    private String zczblx;

    /**
     * 发证机关编号
     */
    private String fzjgbh;

    /**
     * 发证机关名称
     */
    private String fzjgmc;

    /**
     * 法人代表类型
     */
    private String frdblx;

    /**
     * 制证状态
     */
    private String zzzt;



    /**
     * 是否打印
     * @return
     */
    @ModelAnnotation(getName = "是否打印",column = "hasprint",isGrid = false,width = "80px",needTranslate = true,dictName = "hasprint")
    private boolean hasprint;

    /**
     * 打印次数
     */
    @ModelAnnotation(getName = "打印次数",column = "printcount",isGrid = false,width = "80px")
    private String printcount;

    /**
     * 打印时间
     */
    @ModelAnnotation(getName = "打印时间",column = "printTime",isGrid = false,width = "150px")
    private Date printTime;

    /**
     * 生成的pdf文件路径 （正本）
     */
    private String pdfpath;

    /**
     * 生成的pdf文件路径 （副本）
     */
    private String pdfpathRevese;

    /**
     * 打印类型  区分线上1 线下 0
     */
    @ModelAnnotation(getName="数据来源",column = "printtype",isExport = true,isGrid = true,width = "80px",needTranslate = true,dictName = "printType")
    private String printtype;
    /***
     *
     */
    private String qrcode;
    /**
     * 是否旧数据处理或手动导入的数据 1 为 是  0 为不是
     */
    private String hasOld;

    public String getHasOld() {
        return hasOld;
    }

    public void setHasOld(String hasOld) {
        this.hasOld = hasOld;
    }

    private List<ProjectChange> projectChangeList;

    //项目变更信息
    private ProjectChange projectChange;


    /***
     * 1申请2变更
     */
    private String applytype;


    /***
     * 公司ID
     */
    private Long companyid;

    /***
     * 项目记录表ID
     */
    private Long legalchangeId;
    /**
     * 服务范围
     */
    private String fwfw;
    /**
     * 未驻入系统公司名
     */
    private String gsmcDefine;

    /**
     * 监管机构id
     */
    private Long orgId;

    public String getFwfw() {
        return fwfw;
    }

    public void setFwfw(String fwfw) {
        this.fwfw = fwfw;
    }

    public Long getCompanyid() {
        return companyid;
    }

    public void setCompanyid(Long companyid) {
        this.companyid = companyid;
    }

    public Long getLegalchangeId() {
        return legalchangeId;
    }

    public void setLegalchangeId(Long legalchangeId) {
        this.legalchangeId = legalchangeId;
    }

    public List<ProjectChange> getProjectChangeList() {
        return projectChangeList;
    }

    public void setProjectChangeList(List<ProjectChange> projectChangeList) {
        this.projectChangeList = projectChangeList;
    }


    public String getApplytype() {
        return applytype;
    }

    public void setApplytype(String applytype) {
        this.applytype = applytype;
    }

    public ProjectChange getProjectChange() {
        return projectChange;
    }

    public void setProjectChange(ProjectChange projectChange) {
        this.projectChange = projectChange;
    }

    public String getPrinttype() {
        return printtype;
    }

    public void setPrinttype(String printtype) {
        this.printtype = printtype;
    }

    public String getPdfpathRevese() {
        return pdfpathRevese;
    }

    public void setPdfpathRevese(String pdfpathRevese) {
        this.pdfpathRevese = pdfpathRevese;
    }

    public String getPdfpath() {
        return pdfpath;
    }

    public void setPdfpath(String pdfpath) {
        this.pdfpath = pdfpath;
    }

    public boolean isHasprint() {
        return hasprint;
    }

    public void setHasprint(boolean hasprint) {
        this.hasprint = hasprint;
    }

    public String getPrintcount() {
        return printcount;
    }

    public void setPrintcount(String printcount) {
        this.printcount = printcount;
    }

    public Date getPrintTime() {
        return printTime;
    }

    public void setPrintTime(Date printTime) {
        this.printTime = printTime;
    }

    public String getPzwh() {
        return pzwh;
    }

    public void setPzwh(String pzwh) {
        this.pzwh = pzwh;
    }

    public String getPxnr() {
        return pxnr;
    }

    public void setPxnr(String pxnr) {
        this.pxnr = pxnr;
    }

    public String getFrmc() {
        return frmc;
    }

    public void setFrmc(String frmc) {
        this.frmc = frmc;
    }

    public String getGsmc() {
        return gsmc;
    }

    public void setGsmc(String gsmc) {
        this.gsmc = gsmc;
    }

    public String getZczb() {
        return zczb;
    }

    public void setZczb(String zczb) {
        this.zczb = zczb;
    }

    public Date getFzrq() {
        return fzrq;
    }

    public void setFzrq(Date fzrq) {
        this.fzrq = fzrq;
    }

    public String getSlr() {
        return slr;
    }

    public void setSlr(String slr) {
        this.slr = slr;
    }

    public String getSlrsj() {
        return slrsj;
    }

    public void setSlrsj(String slrsj) {
        this.slrsj = slrsj;
    }

    public Date getZzrq() {
        return zzrq;
    }

    public void setZzrq(Date zzrq) {
        this.zzrq = zzrq;
    }

    public String getXkzh() {
        return xkzh;
    }

    public void setXkzh(String xkzh) {
        this.xkzh = xkzh;
    }


    public String getGsdz() {
        return gsdz;
    }

    public void setGsdz(String gsdz) {
        this.gsdz = gsdz;
    }

    public String getZczblx() {
        return zczblx;
    }

    public Long getTraincompanyapplyid() {
        return traincompanyapplyid;
    }

    public void setTraincompanyapplyid(Long traincompanyapplyid) {
        this.traincompanyapplyid = traincompanyapplyid;
    }

    public void setZczblx(String zczblx) {
        this.zczblx = zczblx;
    }

    public String getFzjgbh() {
        return fzjgbh;
    }

    public void setFzjgbh(String fzjgbh) {
        this.fzjgbh = fzjgbh;
    }

    public String getFrdblx() {
        return frdblx;
    }

    public void setFrdblx(String frdblx) {
        this.frdblx = frdblx;
    }

    public String getZzzt() {
        return zzzt;
    }

    public void setZzzt(String zzzt) {
        this.zzzt = zzzt;
    }

    public String getFzjgmc() {
        return fzjgmc;
    }

    public void setFzjgmc(String fzjgmc) {
        this.fzjgmc = fzjgmc;
    }

    public Date getClrq() {
        return clrq;
    }

    public void setClrq(Date clrq) {
        this.clrq = clrq;
    }

    @Override
    public String toString() {
        return "trainCertificate{" +
                "pzwh='" + pzwh + '\'' +
                ", frmc='" + frmc + '\'' +
                ", gsmc='" + gsmc + '\'' +
                ", zczb='" + zczb + '\'' +
                ", fzrq=" + fzrq +
                ", slr='" + slr + '\'' +
                ", slrsj='" + slrsj + '\'' +
                ", zzrq=" + zzrq +
                ", xkzh='" + xkzh + '\'' +
                ", traincompanyapplyid='" + traincompanyapplyid + '\'' +
                ", gsdz='" + gsdz + '\'' +
                ", zczblx='" + zczblx + '\'' +
                ", fzjgbh='" + fzjgbh + '\'' +
                ", frdblx='" + frdblx + '\'' +
                ", zzzt='" + zzzt + '\'' +
                '}';
    }
}
