package com.bcxin.ars.model.certificate;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.SecurityCompany;
import lombok.Data;

import java.util.Date;
import java.util.List;

/***
 * 换证信息
 */
@Data
public class ReplaceCompanyCertificate extends BaseModel {
	/** 批准文号 */
	@ModelAnnotation(getName="批准文号",column = "pzwh",isExport = true,sign= SignType.LIKE)
	private String pzwh;

	/** 服务范围 */
	@ModelAnnotation(getName="服务范围",column = "fwfw",isExport = true,sign= SignType.LIKE)
	private String fwfw;

	/** 法人名称 */
	@ModelAnnotation(getName="法人名称",column = "frmc",isExport = true,sign= SignType.LIKE,isGrid = true,width = "100px")
	private String frmc;

	/** 公司名称 */
	@ModelAnnotation(getName="公司名称",column = "gsmc",isExport = true,sign= SignType.LIKE,isGrid = true,width = "200px")
	private String gsmc;

	/** 注册资本 */
	private String zczb;

	/** 发证日期 */
	private Date fzrq;

	/** 受理人 */
	private String slr;

	/** 受理人手机号 */
	private String slrsj;

	/** 制作日期 */
	private Date zzrq;

	/** 许可证号 */
	private String xkzh;

	/** 保安服务公司申报ID */
	private Long sponsorlicenseid;

	/** 公司地址 */
	private String gsdz;

	/** 注册资本类型 */
	private String zczblx;

	/** 发证机关编号 */
	private String fzjgbh;

	/** 法定代表人类型 */
	private String frdblx;

	/** 制证状态 */
	private String zzzt;

	/** 发证机关名称 */
	private String fzjgmc;

	/** 证书类型 1、变更2、历史3、正常无变更*/
	private String zzlx;

	/**
	 * 其他保安服务范围名称(保安范围为其他则此列必填)
	 */
	private String otherSecScopeType;

	/**
	 * 是否打印
	 * @return
	 */
	private boolean hasprint;

	/**
	 * 打印次数
	 */
	private String printcount;

	/**
	 * 打印日期
	 */
	private Date printTime;

	/**
	 * 生成的pdf文件路径
	 */
	private String pdfpath;

	/**
	 * 生成的pdf文件路径 （副本）
	 */
	private String pdfpathRevese;

	/**
	 * 打印类型  区分线上1 线下 0
	 */
	private String printtype;

	/**
	 * 是否旧数据处理或手动导入的数据 1 为 是  0 为不是
	 */
	private String hasOld;


	/**
	 * 申请类型1申请2变更
	 */
	private String applytype;


	/**
	 * 保安公司类型 01-保安公司，02-武装押运，03-合资
	 */
	private String sponsorlicenseType;



	/***
	 * 项目记录表ID
	 */
	private Long legalchangeId;

	private List<ProjectChange> projectChangeList;

	//项目变更信息
	private ProjectChange projectChange;

	//公司id
	private Long companyId;

	/***
	 * 公司
	 */
	private SecurityCompany company;

}