package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.task.ComTask;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.format.annotation.DateTimeFormat;
import lombok.Data;
import java.util.Date;
import java.util.List;

/**
 * 保安员类
 * @author Ethan
 */
@Data
public class SecurityPerson extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 是否初始化 0未初始化 1已初始化
	 */
	@ModelAnnotation(getName="是否初始化",column = "init")
	private String init;

	@ModelAnnotation(getName="头像",column = "photo")
	private String photo;

	@ModelAnnotation(getName="真实姓名",column = "realName")
	private String realName;
	/**
	 * 手机号码
	 */
	@ModelAnnotation(getName="手机号码",column = "phone")
	private String phone;

	@ModelAnnotation(getName="证件照片",column = "idPhoto")
	private String idPhoto;

	@ModelAnnotation(getName="企业上传的证件照片",column = "comIdPhoto")
	private String comIdPhoto;

	/**
	 * 数据区域
	 */
	@ModelAnnotation(getName="数据区域",column = "native_code")
	private Long nativeCode;

	/**
	 * 年龄
	 */
	@ModelAnnotation(getName="年龄",column = "age")
	private Integer age;
	/**
	 * 性别
	 */
	@ModelAnnotation(getName = "性别",column = "id_number",defaultColumn=true,sign = SignType.IDCARDSEX,needTranslate = true,dictName = "sex")
	private String gender;
	/**
	 * 民族
	 */
	@ModelAnnotation(getName="民族",column = "nation")
	private String nation;

	/**
	 * 籍贯
	 */
	@ModelAnnotation(getName="籍贯",column = "native",isExport = false)
	private Integer natives;

	/**
	 * 身高
	 */
	@ModelAnnotation(getName="身高",column = "stature")
	private Integer stature;

	/**
	 * 血型
	 */
	@ModelAnnotation(getName="血型",column = "blood")
	private String blood;

	/**
	 * 学历
	 */
	@ModelAnnotation(getName="学历",column = "edu")
	private Integer edu;

	/**
	 * 工作经验
	 */
	@ModelAnnotation(getName="工作经验",column = "exp")
	private Integer exp;

	/**
	 * 身份证号
	 */
	@ModelAnnotation(getName="身份证号",column = "id_number")
	private String idNumber;

	/**
	 * 身份证正面
	 */
	@ModelAnnotation(getName="身份证正面",column = "id_card_front")
	private String idCardFront;

	/**
	 * 身份证反面
	 */
	@ModelAnnotation(getName="身份证反面",column = "id_card_reverse")
	private String idCardReverse;

	/**
	 * 居住证
	 */
	@ModelAnnotation(getName="居住证",column = "residence")
	private String residence;

	/**
	 * 身份证地址
	 */
	@ModelAnnotation(getName="身份证地址",column = "id_card_address")
	private String idCardAddress;

	/**
	 * 现居住地址
	 */
	@ModelAnnotation(getName="现居住地址",column = "current_address")
	private String currentAddress;

	/**
	 * 疾病描述
	 */
	@ModelAnnotation(getName="疾病描述",column = "diseases_history")
	private String diseasesHistory;

	/**
	 * 紧急联系人
	 */
	@ModelAnnotation(getName="紧急联系人",column = "emergency_contact_person")
	private String emergencyContactPerson;

	/**
	 * 紧急联系人电话
	 */
	@ModelAnnotation(getName="紧急联系人电话",column = "emergency_contact_phone")
	private String emergencyContactPhone;

	/**
	 * 职业水平
	 */
	@ModelAnnotation(getName="职业水平",column = "profession_level")
	private String professionLevel;

	/**
	 * 职业水平
	 */
	private SecurityProfessionLevel level;
	/**
	 * 证书号
	 */
	@ModelAnnotation(getName="证书号",column = "credential")
	private String credential;

	/**
	 * 五险一金（社保）
	 * 1、已缴交;0、未缴交
	 */
	@ModelAnnotation(getName="五险一金",column = "socialSecurity")
	private String socialSecurity;

	/**
	 * 是否购买意外险，1在保，0未在保
	 */
	@ModelAnnotation(getName="是否购买意外险",column = "insured")
	private String  insured;

	/**
	 * 驾照水平
	 */
	@ModelAnnotation(getName="驾照水平",column = "driving_level")
	private String drivingLevel;

	/**
	 * 持枪证证号
	 */
	@ModelAnnotation(getName="持枪证证号",column = "arm_number")
	private String armNumber;

	/**
	 * 持枪证有效期
	 */
	@ModelAnnotation(getName="持枪证有效期",column = "arm_start")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date armStart;

	/**
	 * 持枪证有效期
	 */
	@ModelAnnotation(getName="持枪证有效期",column = "arm_end")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date armEnd;

	/**
	 * 持枪证单位
	 */
	@ModelAnnotation(getName="持枪证单位",column = "arm_unit")
	private String armUnit;

	/**
	 * 是否参军
	 */
	@ModelAnnotation(getName="是否参军",column = "enrolled")
	private Boolean enrolled;

	/**
	 * 是否参加过押运
	 */
	@ModelAnnotation(getName="是否参加过押运",column = "escorted")
	private Boolean escorted;

	/**
	 * 是否有持枪证
	 */
	@ModelAnnotation(getName="是否有持枪证",column = "arm_licence")
	private Boolean armLicence;

	/**
	 * 是否合格
	 */
	@ModelAnnotation(getName="是否合格",column = "qualified")
	private Boolean qualified;

	/**
	 * 不合格描述
	 */
	@ModelAnnotation(getName="不合格描述",column = "unqualified")
	private String unqualified;

	/**
	 * 星级
	 */
	@ModelAnnotation(getName="星级",column = "star_level")
	private Integer starLevel;

	/**
	 * 在线状态（是否在线）
	 */
	@ModelAnnotation(getName="在线状态",column = "guard_status")
	private Integer guardStatus;

	/**
	 * 在职状态
	 * 0离职 ;1在职
	 */
	@ModelAnnotation(getName="在职状态",column = "incumbencyStatus")
	private String incumbencyStatus;
	/**
	 * 所在经度
	 */
	@ModelAnnotation(getName="所在经度",column = "longitude")
	private String longitude;

	/**
	 * 所在纬度
	 */
	@ModelAnnotation(getName="所在纬度",column = "latitude")
	private String latitude;

	/***
	 *是否身份认证
	 */
	@ModelAnnotation(getName="是否身份认证",column = "identityAuthState")
	private String identityAuthState;

	@ModelAnnotation(getName="身份认证时间",column = "identityAuthTime")
	private String identityAuthTime;

	/**
	 * 政治面貌
	 */
	@ModelAnnotation(getName="政治面貌",column = "politics")
	private String politics;
	/***
	 * 婚姻 2、未婚 1、已婚 3、离异
	 */
	@ModelAnnotation(getName="婚姻",column = "marriage")
	private String marriage;

	/***
	 * 国籍
	 */
	@ModelAnnotation(getName="国籍",column = "nationality")
	private String nationality;
	/**
	 * 培训单位编码
	 */
	@ModelAnnotation(getName="培训单位编码",column = "traincompanyno")
	private String traincompanyno;
	/***
	 * 发证机关编号
	 */
	@ModelAnnotation(getName="发证机关编号",column = "certificatejgno")
	private String certificatejgno;
	/***
	 * 发证机关名称
	 */
	@ModelAnnotation(getName="发证机关名称",column = "certificatejgname")
	private String certificatejgname;
	/***
	 * 发证日期
	 */
	@ModelAnnotation(getName="发证日期",column = "certificatejgtime")
	private String certificatejgtime;

	/***
	 * 培训单位名称
	 */
	@ModelAnnotation(getName="培训单位名称",column = "traincompanyname")
	private String traincompanyname;
	/**
	 * 培训时间
	 */
	@ModelAnnotation(getName="培训时间",column = "traintime")
	private String traintime;
	/***
	 * 背景筛查结果
	 */
	private List<BackgroundApproval> backgroundApprovals;
	/**
	 * 所属公司，部门及角色信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompanyPerson relation;
	/**
	 * 所属公司，部门 信息 列表，包含 离职
	 */
	@JsonIgnoreProperties(value={"handler"})
	private List<SecurityCompanyPerson> relationList;
	/***
	 * 保险产品
	 */
	private String product_name;
	/***
	 * 产品公司
	 */
	private String insurance_ame;
	/***
	 * 有效时间
	 */
	private String inception_date;
	/***
	 * 过期时间
	 */
	private String planned_end_date;
	/***
	 * 保费
	 */
	private String gross_premium;
	/***
	 * 投保人名称
	 */
	private String applicant_name;
	/***
	 * 被保险人数量
	 */
	private String ins_count;

	/***
	 * 资格证培训单位编码
	 */
	@ModelAnnotation(getName="资格证培训单位编码",column = "zgtraincompanyno")
	private String zgtraincompanyno;
	/**
	 * 资格证培训单位名称
	 */
	@ModelAnnotation(getName="资格证培训单位名称",column = "zgtraincompanyname")
	private String zgtraincompanyname;

	/***
	 * 资格证培训时间
	 */
	@ModelAnnotation(getName="资格证培训时间",column = "zgtraintime")
	private String zgtraintime;

	/**
	 * 资格证培训起始时间
	 */
	@ModelAnnotation(getName="资格证培训起始时间",column = "zgtrainstarttime")
	private String zgtrainstarttime;

	/**
	 *资格证培训结束时间
	 */
	@ModelAnnotation(getName="资格证培训结束时间",column = "zgtrainendtime")
	private String zgtrainendtime;

	/**
	 * 持枪证培训起始时间
	 */
	@ModelAnnotation(getName="持枪证培训起始时间",column = "armtrainstarttime")
	private String armtrainstarttime;

	/**
	 *持枪证培训结束时间
	 */
	@ModelAnnotation(getName="持枪证培训结束时间",column = "armtrainendtime")
	private String armtrainendtime;

	/**
	 *持枪证枪型代码
	 */
	@ModelAnnotation(getName="持枪证枪型代码",column = "armtype")
	private String armtype;

	/**
	 *持持枪证发证机关编码
	 */
	@ModelAnnotation(getName="持持枪证发证机关编码",column = "armcertificateno")
	private String armcertificateno;

	/***
	 * 资格证书号
	 */
	@ModelAnnotation(getName="资格证书号",column = "zgcredential")
	private String zgcredential;

	/**
	 * 资格发证机关编号
	 */
	@ModelAnnotation(getName="资格发证机关编号",column = "zgcertificatejgno")
	private String zgcertificatejgno;
	/***
	 *资格发证机关名称
	 */
	@ModelAnnotation(getName="资格发证机关名称",column = "zgcertificatejgname")
	private String zgcertificatejgname;

	/**
	 * 资格发证日期
	 */
	@ModelAnnotation(getName="资格发证日期",column = "zgcertificatejgtime")
	private String zgcertificatejgtime;
	/**
	 * 是否持枪
	 */
	@ModelAnnotation(getName="是否持枪",column = "sfcq")
	private String sfcq;

	/**
	 * 入职日期
	 */
	@ModelAnnotation(getName="入职日期",column = "entrydate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date entrydate;


	/**
	 * 签订日期
	 */
	@ModelAnnotation(getName="签订日期",column = "signdate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date signdate;

	/**
	 * 开始日期
	 */
	@ModelAnnotation(getName="开始日期",column = "htstartdate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date htstartdate;

	/**
	 * 结束日期
	 */
	@ModelAnnotation(getName="结束日期",column = "htenddate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date htenddate;

	/**
	 * 合同年限
	 */
	@ModelAnnotation(getName="合同年限",column = "htLife")
	private String htLife;

	/**
	 * 合同编号
	 */
	@ModelAnnotation(getName="合同编号",column = "htbh")
	private String htbh;

	/**
	 * 合同状态 1已签订、2续签、3已解除、 4、未签订
	 */
	@ModelAnnotation(getName="合同状态",column = "htstate")
	private String htstate;


	/**
	 * 持枪培训公司名称
	 */
	@ModelAnnotation(getName="持枪培训公司名称",column = "armtraincompanyname")
	private String armtraincompanyname;

	/**
	 * 持枪培训公司编号
	 */
	@ModelAnnotation(getName="持枪培训公司编号",column = "armtraincompanyno")
	private String armtraincompanyno;

	/**
	 * 持枪培训时间
	 */
	@ModelAnnotation(getName="持枪培训时间",column = "armtraintime")
	private String armtraintime;

	/**
	 *所属行业协会
	 */
	@ModelAnnotation(getName="所属行业协会",column = "industryassociation")
	private String industryassociation;

	/**
	 *指纹卡号
	 */
	@ModelAnnotation(getName="指纹卡号",column = "fingerprintsno")
	private String fingerprintsno;

	/**
	 *持枪证发证机关
	 */
	@ModelAnnotation(getName="持枪证发证机关",column = "armcertificatejgname")
	private String armcertificatejgname;

	/**
	 * 持枪证发证日期
	 */
	@ModelAnnotation(getName="持枪证发证日期",column = "armcertificatejgtime")
	private String armcertificatejgtime;

	/***
	 * 当前时间在线任务数
	 */
	@ModelAnnotation(getName="当前时间在线任务数",column = "lineTask")
	private Integer lineTask;
	/***
	 * 保险订单号
	 */
	@ModelAnnotation(getName="保险订单号",column = "bxOrderno")
	private String bxOrderno;
	/***
	 * 保险额度
	 */
	@ModelAnnotation(getName="保险额度",column = "insuranceAmount")
	private String insuranceAmount;
	/**
	 * 区域
	 */
	@ModelAnnotation(getName="区域",column = "areacode")
	private String areacode;

	/**
	 * 审查状态003审查通过 004审查不通过
	 */
	@ModelAnnotation(getName="审查状态",column = "censor_status")
	private String censorStatus;

	/**
	 * 审查时间
	 */
	private Date censorTime;

	/**
	 * 人员类别   1内勤人员2普通保安员3武装押运人员
	 */
	@ModelAnnotation(getName="人员类别",column = "personType")
	private String personType;


	/**
	 * 角色名称
	 */
	private String userrolename;

	/**
	 * 机构名称
	 */
	private String userorgname;

	/**
	 *离职时间
	 */
	@ModelAnnotation(getName="离职时间",column = "leaveDate")
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date leaveDate ;

	/***
	 * 籍贯
	 */
	@ModelAnnotation(getName = "籍贯",column = "id_number",sign = SignType.IDCARDNATIVE)
	private String nativePlace;
	/***
	 * 重新背景筛查字段
	 */
	private String censorCriminalStatus;
	/***
	 * 人员驻勤点信息
	 */
	private List<ComTask> comTaskList;

	/***
	 * 任务个数
	 */
	private Integer taskCount;

	/**
	 * 部门id
	 */
	private Long orgId;

	/**
	 * 是否关联驻勤点
	 */
	private String comTaskFlag;

	//背景筛查时是否有异常
	private Boolean censorStatusError = false;
}
