package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import lombok.Data;

import java.util.List;

@Data
public class PoliceRole extends BaseModel {

	/**  */
	private static final long serialVersionUID = -7214174816970924705L;

	/**
	 * 角色名称
	 */
	@ModelAnnotation(getName="角色名称",column = "rolename")

	private String rolename;
	
	/**
	 * 角色说明
	 */
	@ModelAnnotation(getName="角色说明",column = "roledesc")
	private String roledesc;

	/**
	 * 操作权限
	 */
	@ModelAnnotation(getName="操作权限",column = "oprole")
	private String oprole;	
	
	/**
	 * 数据范围
	 */
	@ModelAnnotation(getName="数据范围",column = "datarole")
	private String datarole;	
	
	/**
	 * 所属机构
	 */
	@ModelAnnotation(getName="所属机构",column = "orgname")
	private String orgname;	
	
	/**
	 * 创建者单位
	 */
	@ModelAnnotation(getName="创建者单位",column = "createrorg")
	private String createrorg;	
	
	/**
	 * 创建者
	 */
	@ModelAnnotation(getName="创建者",column = "creater")
	private String creater;	
	
	/**
	 * 人员数
	 */
	@ModelAnnotation(getName="人员数",column = "usernum")
	private Long usernum;

	/**
	 * 操作类型  数据库中不存在
	 */

	private  String optype;

	/**
	 * 机构ID
	 */
	@ModelAnnotation(getName="机构ID",column = "orgid")
	private Long orgid;

	/**
	 * 数据范围类型
	 * 1用户本人数据,2所在机构数据,3所在机构及下属机构数据
	 */
	@ModelAnnotation(getName="数据范围类型",column = "authtype")
	private String authtype;
	/***
	 * 角色类型
	 */
	@ModelAnnotation(getName="角色类型",column = "roletype")
	private String roletype;

	private List<Permission> permissionlist;
	
	private List<DataAuth> dataAuthlist;

	@Override
	public boolean equals (Object o){
		return super.equals(o);
	}

	@Override
	public int hashCode() {
		return super.hashCode();
	}

}
