package com.bcxin.ars.model;

import java.util.ArrayList;
import java.util.List;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

/**
 * 组织架构
 * @author Ethan
 */
public class Organization extends BaseModel {

	private static final long serialVersionUID = 622167690260043356L;

	/**
	 * 区域编号
	 */
	@ModelAnnotation(getName="区域编号",column = "native_code")
	private Long nativeCode;
	
	/**
	 * 所属公司
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompany company;
	
	/**
	 * 组织名称
	 */
	@ModelAnnotation(getName="组织名称",column = "name")
	private String name;
	/***
	 * 组织机构人员
	 */

	private Integer number;
	/***
	 *
	 */
	private List<Long> ids;


	private Long companyId;


	/**
	 * 是否是saas对接的特殊部门  1  是  其他不是
	 */
	private String isSaasSpecial;

	public String getIsSaasSpecial() {
		return isSaasSpecial;
	}

	public void setIsSaasSpecial(String isSaasSpecial) {
		this.isSaasSpecial = isSaasSpecial;
	}

	/**
	 * 上级组织
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})

	private Organization parent;
	
	/**
	 * 下级组织
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<Organization> children = new ArrayList<Organization>();

	public List<Long> getIds() {
		return ids;
	}

	public void setIds(List<Long> ids) {
		this.ids = ids;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public Integer getNumber() {
		return number;
	}

	public void setNumber(Integer number) {
		this.number = number;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public SecurityCompany getCompany() {
		return company;
	}

	public void setCompany(SecurityCompany company) {
		this.company = company;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public Organization getParent() {
		return parent;
	}

	public void setParent(Organization parent) {
		this.parent = parent;
	}

	public List<Organization> getChildren() {
		return children;
	}

	public void setChildren(List<Organization> children) {
		this.children = children;
	}

}
