package com.bcxin.ars.model;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 模型基类
 * @author Ethan
 */
@Data
public class  BaseModel implements Serializable {

	private static final long serialVersionUID = 2220082166930076300L;
	/**
	 * 主键
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long id;
	
	/**
	 * 是否有效
	 */
	private Boolean active;
	
	/**
	 * 创建时间
	 */
	private Date createTime;
	
	/**
	 * 更新时间
	 */
	private Date updateTime;

	/**
	 * 内网更新时间
	 */
	private Date inTime;

	/** 创建人ID */
	private String createBy;

	/**
	 * 更新人
	 */
	private String updateBy;

	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long userid;

	private  String path;

	private  String rankAuth;

	private  String areaCode;

	/**
	 * 是否内网标志 0否1是
	 */
	private Boolean intranet;

	/**
	 * 新增，修改标志
	 */
	private Boolean updateflag;

	/** 监督检查是否入驻系统 */
	private String isInSystem;
	/** 未入驻系统的公司名 */
	private String companyNameDefine;
    //背景筛查时是否有异常
    private Boolean censorStatusError = false;
	/**
	 * 勿删
	 * @param o
	 * @return
	 */
	@Override
	public boolean equals (Object o){
		boolean retVal = false;
		if (o != null && o.getClass().equals(this.getClass())) {
			BaseModel that = (BaseModel) o;
			if (that.getId() != null && this.getId() != null){
				if (that.getId().intValue() == this.getId().intValue() && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
					retVal = true;
				}
			}
		}
		return retVal;
	}

	/**
	 * 勿删
	 * @return
	 */
	@Override
	public int hashCode() {
		return getId().hashCode();
	}

	public Boolean getUpdateflag() {
		return updateflag;
	}

	public void setUpdateflag(Boolean updateflag) {
		this.updateflag = updateflag;
	}
}
