package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;

import java.util.Map;

/**
 * @author linqinglin
 * @date 2020/07/30 0030 14:20
 */
public class LikeAreaCodeExportWhereStrategy implements ExportWhereStrategy {

    @Override
    public String spliceWhereStr(SignType signType, Map<String,String> columnMap, Map<Object, Object> searchParams, Object key) {
        StringBuilder columnStr = new StringBuilder();

        String areaCode = searchParams.get(key).toString();

        if (areaCode.endsWith("0000")) {// 省
            areaCode = areaCode.substring(0, 2) + "____";
        } else if (areaCode.endsWith("00")) {// 市
            areaCode = areaCode.substring(0, 4) + "__";
        }

        columnStr.append(" and ")
                .append(columnMap.get(key))
                .append(" ")
                .append(signType.getOperator())
                .append(" '")
                .append(areaCode)
                .append("%'");

        return columnStr.toString();
    }
}
