package com.bcxin.ars.dto.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import lombok.Data;

@Data
public class ExportRosterDto extends SearchDto<GradeSubsidyRoster> {
    /** 姓名 */
    @ModelAnnotation(column ="name",getName = "姓名",sign = SignType.LIKE)
    private String name;
    /**
     * 所属区域
     */
    @ModelAnnotation(column ="areaCode",getName = "所属区域",sign = SignType.LIKE)
    private String areaCode;

    /** 手机号 */
    @ModelAnnotation(column ="phone",getName = "手机号",sign = SignType.LIKE)
    private String phone;

    /** 身份证号 */
    @ModelAnnotation(column ="idNum",getName = "身份证号",sign = SignType.LIKE)
    private String idNum;

    /** 培训机构 */
    @ModelAnnotation(column ="trainName",getName = "培训机构",sign = SignType.LIKE)
    private String trainName;

    /**报名公司*/
    @ModelAnnotation(column ="comName",getName = "报名公司",sign = SignType.LIKE)
    private String comName;

    /** 线上审批状态 */
    @ModelAnnotation(column ="approvalState",getName = "审批状态")
    private String approvalState;

    /** 审批状态 */
    @ModelAnnotation(column ="offApprovalState",getName = "审批状态")
    private String offApprovalState;

    /** 报名状态 */
    @ModelAnnotation(column ="gradeState",getName = "报名状态")
    private String gradeState;

    /** 材料核对状态 */
    @ModelAnnotation(column ="checkState",getName = "材料核对状态",sign = SignType.EQUAL_NULL_ZERO)
    private String checkState;

    /** 补贴比对状态 */
    @ModelAnnotation(column ="compareStatus",getName = "补贴比对状态",sign = SignType.EQUAL_AND_NULL)
    private String compareStatus;

    /** 等级 */
    @ModelAnnotation(column ="gradeLevel",getName = "等级")
    private String gradeLevel;

    /** 学时进度状态 */
    @ModelAnnotation(column ="periodStatus",getName = "学时进度状态")
    private String periodStatus;

    /** 实习状态 */
    @ModelAnnotation(column ="practiceStatus",getName = "实习状态",sign = SignType.EQUAL_NULL_ZERO)
    private String practiceStatus;

    /** 实习天数 */
    @ModelAnnotation(column ="practiceDay",getName = "实习天数",sign = SignType.EQUAL_NULL_ZERO)
    private Integer practiceDay;

    /** 背景筛查状态 */
    @ModelAnnotation(column ="censorStatus",getName = "背景筛查状态",sign = SignType.EQUAL_NULL_ZERO)
    private String censorStatus;

    /** 考试状态 */
    @ModelAnnotation(column ="testState",getName = "考试状态")
    private String testState;

    /** 班级名称 */
    @ModelAnnotation(column ="className",getName = "班级名称")
    private String className;

    /** 考试报名开始时间 */
    @ModelAnnotation(column ="testTime",getName = "考试报名开始时间",sign = SignType.DATE_GREATER_EQUAL)
    private String testStartTime;

    /** 考试报名结束时间 */
    @ModelAnnotation(column ="testTime",getName = "考试报名结束时间",sign = SignType.DATE_LESS_EQUAL)
    private String testEndTime;

    /** 学习报名开始时间  */
    @ModelAnnotation(column ="applyTime",getName = "学习报名开始时间",sign = SignType.DATE_GREATER_EQUAL)
    private String startTime;

    /**学习报名结束时间 */
    @ModelAnnotation(column ="applyTime",getName = "学习报名结束时间",sign = SignType.DATE_LESS_EQUAL)
    private String endTime;
    /***
     * 班级主键
     */
    @ModelAnnotation(column ="classId",getName = "班级主键")
    private String classId;
    /**
     * 状态
     */
    @ModelAnnotation(column ="subsidyStatus",getName = "状态")
    private String subsidyStatus;
    /**
     * 补贴金额
     */
    @ModelAnnotation(column ="subsidyMoney",getName = "补贴金额")
    private String subsidyMoney;

    /**
     * 是否在批次审批中
     */
    @ModelAnnotation(column ="used",getName = "是否在批次审批中")
    private Boolean used;
    /**
     * 批次id
     *
     */
    @ModelAnnotation(column ="batchId",getName = "批次id")
    private Long batchId;
    /**
     * 培训机构id
     *
     */
    @ModelAnnotation(column ="trainId",getName = "培训机构id")
    private Long trainId;
    /**
     * 公司名称
     */
    @ModelAnnotation(column ="companyName",getName = "公司名称",sign = SignType.LIKE)
    private String companyName;

    /***
     * 导出类型
     */
    @ModelAnnotation(column ="exportType",getName = "导出类型")
    private String exportType;

    /**
     * 批次名称
     */
    @ModelAnnotation(column ="batchName",getName = "批次名称",sign = SignType.LIKE)
    private String batchName;

    /**
     * 申请机构id
     */
    @ModelAnnotation(column ="companyid",getName = "申请机构id")
    private String companyid;

    /**
     * 申请机构
     */
    @ModelAnnotation(column = "trainName", getName = "申请机构", sign = SignType.LIKE)
    private String companynameBatch;

    /**
     * 审批状态
     */
    @ModelAnnotation(column = "approvalstate", getName = "审批状态", sign = SignType.IN)
    private String approvalstateBatch;

    /**
     * 申请开始时间
     */
    @ModelAnnotation(column ="applyTime",getName = "申请开始时间",sign = SignType.DATE_GREATER_EQUAL)
    private String applyStartTime;

    /**
     * 申请结束时间
     */
    @ModelAnnotation(column ="applyTime",getName = "申请结束时间",sign = SignType.DATE_LESS_EQUAL)
    private String applyEndTime;

    /**
     * 审批结束开始时间
     */
    @ModelAnnotation(column ="approvaldate",getName = "审批开始时间",sign = SignType.DATE_GREATER_EQUAL)
    private String approvalStartTime;

    /**
     * 审批结束时间
     */
    @ModelAnnotation(column ="approvaldate",getName = "审批结束时间",sign = SignType.DATE_LESS_EQUAL)
    private String approvalEndTime;
    /**
     * 补贴证书类型
     */
    @ModelAnnotation(column ="subsidyCerType",getName = "补贴证书类型")
    private String subsidyCerType;
    /**
     * 驻勤点名称
     */
    @ModelAnnotation(column = "taskName",getName = "驻勤点名称",sign = SignType.LIKE)
    private String taskName;
    /**
     * 保安员人数
     */
    @ModelAnnotation(column = "perNum",getName = "保安员起始人数",sign = SignType.GREATER_EQUAL)
    private Integer startPerNum;
    @ModelAnnotation(column = "perNum", getName = "保安员结束人数", sign = SignType.LESS_EQUAL)
    private Integer endPerNum;
    /**
     * 填报时间
     */
    @ModelAnnotation(column = "filledByTime", getName = "填报开始时间", sign = SignType.DATE_GREATER_EQUAL)
    private String startFilledByTime;
    @ModelAnnotation(column = "filledByTime", getName = "填报结束时间", sign = SignType.DATE_LESS_EQUAL)
    private String endFilledByTime;

    @ModelAnnotation(column = "applyTime", getName = "申请时间", isExport = false)
    private String applyTime;
}
