package com.bcxin.ars.dto.subsidy;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import lombok.Data;

/**
 * @author  yyx
 * @date 2020-05-14
 * @desc 花名册
 */
@Data
public class GradeSubsidyRosterSearchDto extends SearchDto<GradeSubsidyRoster> {
    /**
     * 状态
     */
    private String subsidyStatus;

    /**
     * 是否在批次审批中
     */
    private String used;
    /**
     * 姓名
     */
    private String name;
    /**
     * 身份证号
     */
    private String idNum;

    /**
     * 手机号
     *
     */
    private String phone;
    /**
     * 批次id
     *
     */
    private Long batchId;
    /**
     * 培训机构id
     *
     */
    private Long trainId;
    /**
     * 培训公司
     */
    private String trainName;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     *  补贴金额
     */
    private String subsidyMoney;

    /**
     * 补贴证书类型 01等级证 or 02资格证
     */
    private String subsidyCerType;

    /**
     * 报名审批状态
     */
    private String approvalState;

    /**
     * 可补贴
     */
    private String canSubsidy;

}
