package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import lombok.Data;

/**
 * 公司分页搜索dto
 * @author linqinglin
 * @date 2019/05/14 0014 13:46
 */
@Data
public class CompanyPageSearchDto extends SearchDto<CompanyDto> {

    /**
     * 公司名称
     */
    private String name;

    /**
     * 法人姓名
     */
    private String legalPerson;

    /**
     * 法人电话
     */
    private String phone;

    /**
     * 机构类型
     */
    private String sponsorlicenseType;

    /**
     * 负责人姓名
     */
    private String principal;

    /**
     * 负责人电话
     */
    private String principalPhone;

    /**
     * 经营范围
     */
    private String securityScopeType;

    /**
     * 机构类型
     */
    private String institutionType;

    /**
     * 公司状态(废弃)
     */
    private String state;

    /**
     * 公司状态
     */
    private String companyState;

    /***
     * 是否子公司
     */
     private String isSubsidiary;

    /**
     * 是否旧数据
     */
    private Boolean oldData;

    /**
     * 培训内容
     */
    private String trainContent;

    /**
     * 是否本地公司
     */
    private Boolean local;
    protected Integer pageNumber;//页数
    protected Integer pageSize;//每页显示几条

    /**
     * 保安师数
     */
    private Integer securityGuardCount;

    /**
     * 公司股东数
     */
    private Integer managerCount;

    /**
     * 保安员数
     */
    private Integer countPerson;

    /**
     * 驻勤点数
     */
    private Integer stationingNum;


    @Override
    public Integer getStart() {
        return (this.pageNumber == null ? 0:(this.pageNumber-1)) * (this.pageSize == null ? 0:this.pageSize);
    }
}
