package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;

@Data
public class TrainInspectionExportDto {
    /** 机构类型 */
    @ModelAnnotation(getName="机构类型",column = "institutionType",isExport = true,needTranslate = true,dictName ="institutionType")
    private String institutionType;

    /** 公司名称 */
    @ModelAnnotation(getName = "公司名称",column = "company_name",isExport = true,sign = SignType.LIKE)
    private String companyName;

    /** 检查公安机关 */
    @ModelAnnotation(getName="检查公安机关",column = "check_org",isExport = true)
    private String checkOrg;
    /** 检查公安机关id */
    @ModelAnnotation(getName="检查公安机关id",column = "check_org_id",sign = SignType.EQUAL_NULL_ZERO)
    private String checkOrgId;

    /** 检查人 */
    @ModelAnnotation(getName="检查人",column = "checker",isExport = true)
    private String checker;

    /** 检查时间 */
    @ModelAnnotation(getName="检查时间",column = "check_date",isExport = true)
    private String checkDate;

    /** 检查查询开始时间 */
    @ModelAnnotation(getName="检查时间开始时间",column = "check_date",sign = SignType.DATE_GREATER_EQUAL)
    private String startDate;

    /** 检查查询结束时间 */
    @ModelAnnotation(getName="检查时间开始时间",column = "check_date",sign = SignType.DATE_LESS_EQUAL)
    private String endDate;

    /** 作出处理决定公安机关 */
    @ModelAnnotation(getName="作出处理决定公安机关",column = "handle_org",isExport = true)
    private String handleOrg;

    /** 登记机构 */
    @ModelAnnotation(getName = "登记机构",column = "org_name",isExport = true)
    private String orgName;

    /** 登记人 */
    @ModelAnnotation(getName = "登记人",column = "register",isExport = true)
    private String register;

    /** 公司检查问题 */
    @ModelAnnotation(getName = "公司检查问题",column = "company_question",isExport = true)
    private String companyQuestion;

    /** 检查内容 */
    @ModelAnnotation(getName = "检查内容 ",column = "content",isExport = true)
    private String content;

    /** 检查记录 */
    @ModelAnnotation(getName = "检查记录 ",column = "record",isExport = true)
    private String record;

    /** 整改要求 */
    @ModelAnnotation(getName = "整改要求 ",column = "rectify_require",isExport = true)
    private String rectifyRequire;

    /** 复查情况 */
    @ModelAnnotation(getName = "复查情况 ",column = "review",isExport = true)
    private String review;

    /** 数据来源 */
    @ModelAnnotation(getName="数据来源",column = "dataSource",isExport = true,needTranslate = true,dictName ="dataSource")
    private String dataSource;

    /** 被检查人签名 */
    @ModelAnnotation(getName = "被检查人签名 ",column = "signImgPath",isExport = true)
    private String signImgPath;
}
