package com.bcxin.ars.dto.epidemic;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.epidemic.Epidemic;
import lombok.Data;

import java.util.Date;


/**
 *
 * 疫情防控参数
 * @author subh
 */
@Data
public class EpidemicSearchDto extends SearchDto<Epidemic> {

    @ModelAnnotation(getName="公司名称",isExport = true,column  = "companyName",sign= SignType.LIKE)
    private String companyName;
    @ModelAnnotation(getName="填表人",isExport = true,column  = "filledBy")
    private String filledBy;
    @ModelAnnotation(getName="填报人电话",isExport = true,column  = "filledByPhone")
    private String filledByPhone;
    @ModelAnnotation(getName="填报时间",isExport = true,column  = "filledByTime")
    private Date filledByTime;
    @ModelAnnotation(getName="驻勤点名称",isExport = true,column  = "taskName")
    private String taskName ;
    @ModelAnnotation(getName="驻勤点详细地址",isExport = true,column  = "taskAddress")
    private String taskAddress;
    @ModelAnnotation(getName="监管机构",isExport = true,column  = "orgName")
    private String orgName;
    @ModelAnnotation(getName="监管机构ID",isExport = true,column  = "orgId")
    private Long orgId;
    @ModelAnnotation(getName="所属区域",isExport = true,column  = "areaCode")
    private String areaCode;
    @ModelAnnotation(getName="保安员总人数",isExport = true,column  = "perNum")
    private Long perNum;
    @ModelAnnotation(getName="已做核酸未出结果人数",isExport = true,column  = "nucleicNum")
    private Long nucleicNum;
    @ModelAnnotation(getName="未做核酸检测人数",isExport = true,column  = "unNucleicNum")
    private Long unNucleicNum;
    @ModelAnnotation(getName="核酸检测呈阳性人数",isExport = true,column  = "nucleicPositiveNum")
    private Long nucleicPositiveNum;
    @ModelAnnotation(getName="确诊人数",isExport = true,column  = "diagnosisNum")
    private Long diagnosisNum;
    @ModelAnnotation(getName="政府集中隔离人数",isExport = true,column  = "quarantineGovNum")
    private Long quarantineGovNum;
    @ModelAnnotation(getName="公司集中隔离",isExport = true,column  = "quarantineComNum")
    private Long quarantineComNum;
    @ModelAnnotation(getName="驻勤点原地隔离人数",isExport = true,column  = "quarantineTaskNum")
    private Long quarantineTaskNum;
    @ModelAnnotation(getName="隔离总人数",isExport = true,column  = "quarantineNum")
    private Long quarantineNum;
    @ModelAnnotation(getName="核酸检测点",isExport = true,column  = "quarantineNum")
    private Long checkHospital;


    /***
     * 单位userid
     */
    private Long userId;


    /**
     * 开始人数
     */
    private String startPerNum;

    /**
     * 结束人数
     */
    private String endPerNum;


    /***
     * 填报开始时间
     */
    private String startFilledByTime;


    /***
     * 填报结束时间
     */
    private String endFilledByTime;


    /**
     *今日是否补充街道信息
     */
    private String streetSupplement;

    @ModelAnnotation(getName="所属街道",isExport = true,column  = "streetName",sign= SignType.LIKE)
    private String streetName;
    @ModelAnnotation(getName="风险级别",isExport = true,column  = "riskLevel",sign= SignType.EQUAL)
    private String riskLevel;
}
