package com.bcxin.ars.dto;

import com.bcxin.ars.model.SecurityGuard;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 保安师库搜索类O
 *
 * @author wangjianchi
 * @date 2019-3-19 14:58
 */
@Data
public class SecurityGuardSearchDto extends SearchDto<SecurityGuard> {

    private static final long serialVersionUID = -4120374918995197620L;
    /**
     * 主键
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /***
     * 颁证开始日期
     */
    private String certificatejgStartTime;

    /***
     * 颁证结束日期
     */
    private String certificatejgEndTime;

    /**
     * 身份证号
     */
    private String idNumber;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String sex;

    /**
     * 职业
     */
    private String profession;

    /**
     * 职业级别
     */
    private String professionLevel;

    /**
     * 文化程度
     */
    private String edu;

    /***
     * 服务开始时间
     */
    private String serviceStartTime;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 证书编号
     */
    private String credential;

    /***
     * 颁证日期
     */
    private String certificatejgtime;

    /***
     * 工作地点
     */
    private String workPlace;

    /***
     * 准考证号
     */
    private String ticketNum;

    /***
     * 服务保安公司
     */
    private String securityCompany;

    /***
     * 理论成绩
     */
    private String writtenScore;

    /***
     * 体能成绩
     */
    private String operateScore;

    /***
     * 综合成绩
     */
    private String sumScore;

    /**
     * 培训机构id
     */
    private Long trainId;

    /**
     * 培训机构
     */
    private String trainName;
}