package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.task.TaskPersonScheduleDao;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.model.task.TaskPersonScheduleDetail;


@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskPersonScheduleDaoTest {

	@Autowired
	private TaskPersonScheduleDao personScheduleDao;

	@Test
	public void testAll() {
		TaskPersonSchedule personSchedule = new TaskPersonSchedule();
		personSchedule.setNativeCode(11l);
		personSchedule.setTaskDate("2017-12-20");
		personSchedule.setTaskPersonId(1l);
		Long id = personScheduleDao.save(personSchedule);
		Assert.assertTrue(id.longValue() > 0);
		List<TaskPersonSchedule> data = personScheduleDao.findByTaskPersonId(1l);
		Assert.assertTrue(data.size() > 0);
		personScheduleDao.deleteByTaskPersonId(1l);
		data = personScheduleDao.findByTaskPersonId(1l);
		Assert.assertTrue(data.size() == 0);
	}
	
	@Test
	public void testDetailAll() {
		TaskPersonScheduleDetail detail = new TaskPersonScheduleDetail();
		detail.setNativeCode(11l);
		detail.setPersonScheduleId(1l);
		detail.setScheduleId(2l);
		Long id = personScheduleDao.saveDetail(detail);
		Assert.assertTrue(id > 0);
		TaskPersonSchedule personSchedule = new TaskPersonSchedule();
		personSchedule.setId(1l);
		personScheduleDao.deleteDetailByPersonSchedule(personSchedule);
	}

}
