package com.bcxin.ars.dao.epidemic;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.bcxin.ars.dao.sys.ExportConfigColumnDao;
import com.bcxin.ars.dao.sys.ExportConfigDao;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.model.sys.ExportConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 疫情防控日志切面
 * @author subh
 */
@Service
public class EpidemicDaoAop {
    @Autowired
    private EpidemicDao epidemicDao;

    @DataChangeAnnotation(getEntityClazz = Epidemic.class,
            getDaoClazz = EpidemicDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int update(Epidemic epidemic) {
        return epidemicDao.update(epidemic);
    }
}
