package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CerLearnRecordPageSearchDto;
import com.bcxin.ars.model.sb.CerLearnRecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 资格证/等级证学习记录Dao接口
 * 
 * @author lin
 * @date 2020-09-08
 */
public interface CerLearnRecordDao{

    /****
     * 删除
     * @param cerLearnRecord
     * @return
     */
    int delete(CerLearnRecord cerLearnRecord);

    /****
     * 保存
     * @param cerLearnRecord
     * @return
     */
    int save(CerLearnRecord cerLearnRecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
        CerLearnRecord findById(Long id);

    /****
     * 选择修改
     * @param cerLearnRecord
     * @return
     */
    int updateSelective(CerLearnRecord cerLearnRecord);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<CerLearnRecord> searchForPage(CerLearnRecordPageSearchDto searchDto, AjaxPageResponse<CerLearnRecord> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<CerLearnRecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<CerLearnRecord> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<CerLearnRecord> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<CerLearnRecord> findByBatchId(@Param("list") List<CerLearnRecord> list);


}
