package com.bcxin.ars.dao.exam;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamPersonHistoryDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

public interface TrainExamPersonDao {

	List<TrainExamPerson> query(TrainExamPersonSearchDto dto, AjaxPageResponse<?> page);
	/**
	 *
	 * @Decription:流程删除已安排考试的人
	 * @author：zhongjianhui
	 * @method  deleteTest
	 * @date：2018/12/27 10:58
	 * @params： * @param idNumber
	 * @return void
	 */
	void deleteTest(String idNumber);
    /**
     *
     * @Decription:流程打回通过审批id删除已安排考试的人
     * @author：zhongjianhui
     * @method  deleteTest
     * @date：2018/12/27 10:58
     * @params： * @param idNumber
     * @return void
     */
    void deleteTestForApporvalId(Long[] personId);
	/**
	 * 根据保安员证人员ID查看人员所有考试信息
	 *
	 * @param dto
	 * @param page
	 * @return
	 */
	List<TrainExamPersonHistoryDto> queryHistory(TrainExamPersonSearchDto dto, AjaxPageResponse<?> page);

	TrainExamPerson findById(long id);

	/**
	 * 根据ID删除人员信息
	 * 
	 * @param id
	 */
	void deleteById(long id);

	/**
	 * 修改考试人员成绩信息
	 * 
	 * @param trainExamPerson
	 */
	void updateScore(TrainExamPerson trainExamPerson);

	/**
	 * 批量新增考试学员到指定考场功能
	 *
	 * @param trainExamPersons
	 * @return
	 */
	void batchSave(List<TrainExamPerson> trainExamPersons);

	/**
	 * 查询考试人员信息
	 * 
	 * @param dto
	 * @return
	 */
	List<TrainExamPerson> list(TrainExamPersonSearchDto dto);

	/**
	 * 批量修改考试人员成绩信息
	 * 
	 * @param persons
	 */
	void updatePScore(List<TrainExamPerson> persons);

	/**
	 * 批量修改人员考试通知状态
	 * 
	 * @param ids
	 */
	void updateBatchYesNoticeStateByPrimaryKey(List<Long> ids);

	/**
	 * 批量修改考试人员成绩通知状态
	 * 
	 * @param ids
	 */
	void updateBatchYesScoreStateByPrimaryKey(List<Long> ids);

	/**
	 * 查询考试人员信息
	 * 
	 * @param dto
	 * @return
	 */
	List<TrainExamPerson> checkPersonInExam(List<String> list);

	/**
	 * 查询考试人员信息
	 * 
	 * @param dto
	 * @return
	 */
	List<TrainExamPerson> exitScore(Long id);

	/**
	 * 批量新增、修改考试人员信息
	 *
	 * @param list
	 * @return
	 */
	void batchSaveAndUpdate(List<TrainExamPerson> list);

	/**
	 * 导入考试人员信息
	 * 
	 * @param searchDto
	 * @return
	 */
	List<TrainExamPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 导入数据更新
	 * 
	 * @param trainExamPerson
	 */
	void updateForDS(TrainExamPerson trainExamPerson);

	/**
	 * 导入数据保存
	 * 
	 * @param trainExamPerson
	 */
	void saveForDS(TrainExamPerson trainExamPerson);

	/**
	 * 查询已录入但未通知考试人员列表
	 * 
	 * @param dto
	 * @return
	 */
	List<TrainExamPerson> getScorelist(TrainExamPersonSearchDto dto);

	/**
	 * 根据考试人员主键集合批量返回主键以及更新时间
	 * 
	 * @param list
	 * @return
	 */
	List<TrainExamPerson> getExamPersonUpdate(List<TrainExamPerson> list);

	/**
	 * 批量修改人员考试通知为未通知状态
	 * 
	 * @param ids
	 */
	void updateBatchNotNoticeStateByPrimaryKey(List<Long> ids);

	/**
	 * 根据身份证号跟考试考场主键查询
	 * @param cardnumber
	 * @param examID
	 * @return
	 */
	TrainExamPerson findByExamIdAndIDNumber(@Param("cardnumber") String cardnumber, @Param("examID") String examID);
}