package com.bcxin.ars.dao.epidemic;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.dto.epidemic.EpidemicSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/***
 * 疫情防控
 * @author subh
 */
public interface EpidemicDao {
    /****
     * 保存
     * @param record
     * @return
     */
    int insert(Epidemic record);
    /**
     * 根据ID获取
     * @param id
     * @return
     */
    Epidemic findById(Long id);

    Epidemic findByIdWithOutCache(Long id);

    /***
     * 更新
     * @param record
     * @return
     */
    int update(Epidemic record);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    List<Epidemic> searchForPage(EpidemicSearchDto searchDto, AjaxPageResponse<Epidemic> page);
    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<Epidemic> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);
    /**
     * 根据UserId获取记录列表
     * @param userId
     * @return
     */
    List<Epidemic> findByUserId(Long userId);
    /***
     * 查询
     * @param epidemic
     * @return
     */
    List<Epidemic> find(Epidemic epidemic);

    /***
     * 根据日期和userid获取数据
     * @param epidemic
     * @return
     */
    List<Epidemic> findUserIdAndDate(Epidemic epidemic);
    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<Epidemic> list);

    /***
     * 查询未补充街道个数
     * @param epidemic
     * @return
     */
    long findByStreetCount(Epidemic epidemic);
}