package com.bcxin.ars.dao.certificate;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

public interface CompanyCertificateDao {

	void delete(CompanyCertificate companyCertificate);

	Long save(CompanyCertificate companyCertificate);

	CompanyCertificate findById(long id);

	void update(CompanyCertificate companyCertificate);

	List<CompanyCertificate> search(CompanyCertificateSearchDto dto);

	Long searchCount(CompanyCertificateSearchDto dto);

	CompanyCertificate findBySponsorLicenseId(Long sponsorlicenseid);

	String searchMaxXkzhCount(CompanyCertificateSearchDto dto);

    CompanyCertificate findByCompanyname(String companyname);

	CompanyCertificate findByCompanyId(Long id);

    List<CompanyCertificate> findByXkzh(String xkzh);

    List<CompanyCertificate> findDataByXkzhHistory(String xkzh);

    List<CompanyCertificate> searchLegalangeChange(CompanyCertificateSearchDto dto);

	Long searchLegalangeChangeCount(CompanyCertificateSearchDto dto);

	/**
	 * 查询未生成PDF的记录
	 * @return
	 */
    List<CompanyCertificate> searchUnPdf();

	List<CompanyCertificate> searchForPage(CompanyCertificateSearchDto dto, AjaxPageResponse<CompanyCertificate> page);

	/**
	 * 外导内数据查询
	 * @param searchDto
	 * @return
	 */
	List<CompanyCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 * 内导外查询
	 * @param startDate
	 * @return
	 */
	List<CompanyCertificate> findDSOutList(String startDate);

	/**
	 * 根据ids查询
	 * @param list
	 * @return
	 */
	List<CompanyCertificate> findByBatchId(List<CompanyCertificate> list);

	/**
	 * 批量保存
	 * @param list
	 */
	void saveBatch(List<CompanyCertificate> list);

}