var imgHeight = 0;
var imgWidth = 0;

function getImageWidth(url, callback) {
	var img = new Image();
	img.src = url;
	// 如果图片被缓存，则直接返回缓存数据
	if (img.complete) {
		callback(img.width, img.height);
	} else {
		// 完全加载完毕的事件
		img.onload = function() {
			callback(img.width, img.height);
		}
	}
}

function viewImg(imgPath) {
	imgHeight = 0;
	imgWidth = 0;
	if (document.getElementById("imgDiv")){
		$("#viewImg").attr("src", imgPath);
	} else {
	    $("body").append('<div style="display: none;" id="imgDiv" class="layui-layer-wrap"><img id="viewImg" src="'+imgPath+'"></div>');
	}
	getImageWidth(imgPath,function(w,h){
		console.log({width:w,height:h});
		imgHeight = h;
    	imgWidth = w+20;
    	if(imgWidth >0 && imgHeight > 0){
		    var iframeHeight = $(window).height();
		    var iframeWidth = $(window).width();
    		if(imgHeight > iframeHeight-50)
    			imgHeight = '90%';
    		else
    			imgHeight = imgHeight +"px";
    		if(imgWidth > iframeWidth-50)
    			imgWidth = '90%';
    		else
    			imgWidth = imgWidth + "px";
			layer.open({
				type : 1,
				title : false,
				closeBtn : 1,
				area : [ imgWidth, imgHeight ],
				skin : 'layui-layer-nobg', //没有背景色
				shadeClose : true,
				scrollbar : false,
				content : $("#imgDiv")
			});
		}
	});
}