
wx.config({
	debug : false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
	appId : '${appid}', // 必填，公众号的唯一标识
	timestamp : '${timestamp}', // 必填，生成签名的时间戳
	nonceStr : '${noncestr}', // 必填，生成签名的随机串
	signature : '${sign}',// 必填，签名，见附录1
	jsApiList : [ 'closeWindow', 'chooseImage', 'previewImage', 'uploadImage' ]
	// 必填，需要使用的JS接口列表，所有JS接口列表见附录2
});
//关闭窗口
function wechatCloseForm(){
	WeixinJSBridge.call('closeWindow');
}

//关闭weui式的弹出窗口
function closeWechatDialog(objId) {
	$("#" + objId).hide();
}

//拍照或从手机相册中选图接口
function chooseImage() {
	wx.chooseImage({
		count : 9, // 默认9
		sizeType : [ 'compressed' ], // 可以指定是原图还是压缩图，默认二者都有
//		sizeType : [ 'original', 'compressed' ], // 可以指定是原图还是压缩图，默认二者都有
		sourceType : [ 'album', 'camera' ], // 可以指定来源是相册还是相机，默认二者都有
		success : function(res) {
			//layer.msg(JSON.stringify(res));
			var localIds = res.localIds; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
			uploadWXImages(localIds);
		}

	});
}

//微信上传多张图片
function uploadWXImages(localIds) {
	var i = 0; var length = localIds.length;
    var upload = function() {
        wx.uploadImage({
            localId:localIds[i],
            isShowProgressTips : 1, // 默认为1，显示进度提示
            success: function(res) {
            	var serverId = res.serverId; // 返回图片的服务器端ID
                var localData = localIds[i];
                // if(window.__wxjs_is_wkwebview){
                //     localData = res.localData;
                //     localData = localData.replace('jgp', 'jpeg');
                // }

    			$("#mediaIdsArea").append("<input type='hidden' name='mediaIds' id='"+serverId+"' value='"+serverId+"'>");
    			var showImg = "";
    			showImg = "<li id='showImg"+serverId+"'><p>";
    			showImg = showImg + "<img onclick=\"preViewImg('"+localData+"');\" src='"+localData+"' class='pic'></p>";
    			showImg = showImg + "<span onclick='removeNewImg(\""+serverId+"\")'><img class='closePic' src='"+baseUrl+"/resources/wechat2/images/picture-close.png' /></span></li>";
    			$("#showImgArea").append(showImg);
                //如果还有照片，继续上传
                i++;
                if (i < length) {
                    upload();
                }
            }
        });                    
    };
    upload();
}

//微信上传单张图片
function uploadWXImage(localId) {
	wx.uploadImage({
		localId : localId, // 需要上传的图片的本地ID，由chooseImage接口获得
		isShowProgressTips : 1, // 默认为1，显示进度提示
		success : function(res) {
			var serverId = res.serverId; // 返回图片的服务器端ID
			$("#mediaIdsArea").append("<input type='hidden' name='mediaIds' id='"+serverId+"' value='"+serverId+"'>");
		}
	});
}

//预览图片
function preViewImg(imgUrl) {
	wx.previewImage({
		current : imgUrl, // 当前显示图片的http链接
		urls : [ imgUrl ]
	// 需要预览的图片http链接列表
	});
}

//拍照或从手机相册中选图接口
function chooseImageForLayer() {
	parent.wx.chooseImage({
		count : 9, // 默认9
		sizeType : [ 'compressed' ], // 可以指定是原图还是压缩图，默认二者都有
//		sizeType : [ 'original', 'compressed' ], // 可以指定是原图还是压缩图，默认二者都有
		sourceType : [ 'album', 'camera' ], // 可以指定来源是相册还是相机，默认二者都有
		success : function(res) {
			//layer.msg(JSON.stringify(res));
			var localIds = res.localIds; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
			uploadWXImagesForLayer(localIds);
		}
	});
}

//微信上传多张图片
function uploadWXImagesForLayer(localIds) {
	var i = 0; var length = localIds.length;
    var upload = function() {
    	parent.wx.uploadImage({
            localId:localIds[i],
            isShowProgressTips : 1, // 默认为1，显示进度提示
            success: function(res) {
            	var serverId = res.serverId; // 返回图片的服务器端ID
                var localData = localIds[i];
                // if(window.__wxjs_is_wkwebview){
                //     localData = res.localData;
                //     localData = localData.replace('jgp', 'jpeg');
                // }

    			$("#mediaIdsArea").append("<input type='hidden' name='mediaIds' id='"+serverId+"' value='"+serverId+"'>");
    			var showImg = "";
                showImg = "<li id='showImg"+serverId+"'><p>";
				showImg = showImg + "<img onclick=\"preViewImgForLayer('"+localData+"');\" src='"+localData+"' class='pic'></p>";
				showImg = showImg + "<span onclick='removeNewImg(\""+serverId+"\")'><img class='closePic' src='"+baseUrl+"/resources/wechat2/images/picture-close.png' /></span></li>";
                $("#showImgArea").append(showImg);
                //如果还有照片，继续上传
                i++;
                if (i < length) {
                    upload();
                }
            }
        });                    
    };
    upload();
}

//预览图片
function preViewImgForLayer(imgUrl) {
	parent.wx.previewImage({
		current : imgUrl, // 当前显示图片的http链接
		urls : [ imgUrl ]
	// 需要预览的图片http链接列表
	});
}