<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>场馆信息维护</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<script type="text/javascript" src="${ctxStatic}/js/juicer-min.js"></script>
	<script type="text/javascript" src="${ctxStatic}/commonJS/wechat/extendPagination.js"></script>
</head>
<body>
<div style="display:flex; height:50px; line-height:50px;background:#FFF;border-bottom:1px solid #DDD;"  onclick="javascript:location.href='/wechat/index?_check=3'">
	<div style="width:5%;font-size:18px; padding-left:15px;">   <   </div>
	<div style="width:95%; text-align:center; text-indent:-10px; font-size:18px;">   场馆信息维护   </div>
</div>
	<form id="venueSearchForm" class="form-inline commom-search-div">
		<input type="hidden" name="pageNum" id="current" value="1" />
		<input type="hidden" name="numPerPage" id="size" value="10" />
		<input type="hidden" name="totalCount" id="total" value="0">

	<div class="container-fluid bg-6f pt-10">
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>场馆类型 :</label></div>
				<div class="tatr-right">
					<span>
						<select name="venueType" id="venueType">
			                <option value="">请选择场馆类型</option>
							<option value="1">体育场馆</option>
							<option value="2">展览馆</option>
							<option value="3">室外场地</option>
							<option value="4">展厅</option>
			            </select>
					</span>
				</div>
			</div> 
			<div class="task-transfer clearfix" >
				<div class="tatr-left"><label><strong>*</strong>所属省：</label></div>
				<div class="tatr-right">
					<span>
						<select name="province" id="id_provSelect" onchange="initCityRegion()">
							<option value=''>请选择省份</option>
						</select>
					</span>
				</div>
			</div>
			<div class="task-transfer clearfix" >
				<div class="tatr-left"><label><strong>*</strong>所属市：</label></div>
				<div class="tatr-right">
					<span>
						<select name="city" id="id_citySelect">
							<option value=''>请选择市</option>
						</select>
					</span>
				</div>
			</div> 
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>&nbsp;</label></div>
				<div class="tatr-right"><span><input type="text" placeholder="请输入场馆名称" id="venueName" name="name"></span></div>
			</div>
			<div class="text-center submit-btn">
				<a href="javascript:submitVenueSearch();" class="btn btn-primary bg-2e9fe3">确定</a>
			</div>
		</div>
		<div class="choice-table" id="pageDetail-c">
			
		</div>
		<nav class="text-center">
			<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
		</nav>
	</form>
</body>


<script id="venue-pageDetail-tpl" type="text/template">
    <table class="table">
        <thead>
        <tr>
        <th style="width: 40%">场馆名称</th>
        <th style="width: 40%">场馆地址</th>
        <th style="width: 10%">联系电话</th>
        <th style="width: 10%">操作</th>
        </tr>
        </thead>
        <tbody>
		{@each data as item, index}
        <tr>
        <td style="width: 40%">\${item.name }&nbsp</td>
        <td style="word-wrap:break-word;word-break:break-all;width: 40%">\${item.venueAddress }&nbsp</td>
        <td style="width: 10%">\${item.phone }&nbsp</td>
        <td style="width: 10%">
        <a href="javascript:editVenue('\${item.oid }');">修改</a>
        </td>
        </tr>
		{@/each}
		{@if data.length == 0}
        <tr>
        <td colspan="4" style="text-align: center;">没有搜索到数据</td>
        </tr>
		{@/if}
        </tbody>
        </table>
</script>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

    juicer.set({
        'tag::operationOpen': '{@',
        'tag::operationClose': '}',
        'tag::interpolateOpen': '\\${',
        'tag::interpolateClose': '}',
        'tag::noneencodeOpen': '\\$\\${',
        'tag::noneencodeClose': '}',
        'tag::commentOpen': '\\{#',
        'tag::commentClose': '\\}'
    });

    $(function () {
        initProvinceRegion();
        submitVenueSearch();
    });
    
	function initProvinceRegion(){
        $.ajax({
            type: 'POST',
            url: baseUrl + "/public/provinceList.json",
            async: false,
            success: function(data){
            	$("#id_provSelect").empty();
        		$("#id_provSelect").append("<option value=''>" + "请选择省份" + "</option>");
                for(var i=0;i <data.length;i++){
                    $("#id_provSelect").append("<option value='"+data[i].oid+"'>"+data[i].province+"</option>");
                }
            },
            error:function (XMLHttpRequest, textStatus, errorThrown){
                alert('请求失败');
            }
        });
    }

    function initCityRegion(){
    	$("#id_citySelect").empty();
		$("#id_citySelect").append("<option value=''>" + "请选择城市" + "</option>");
        var province = $("#id_provSelect").val();
        $.ajax({
            type: 'POST',
            url: baseUrl + "/public/getRegionByParent.json",
            data:{'parentId':province},
            async: false,
            success: function(data){
                for(var i=0;i <data.length;i++){
                    $("#id_citySelect").append("<option value='"+data[i].oid+"'>"+data[i].city+"</option>");
                }

            },
            error:function (XMLHttpRequest, textStatus, errorThrown){
                alert('请求失败');
            }
        });
    }

    function submitVenueSearch(){
        pager("#venueSearchForm");
    }

    //分页插件
    function initPage(formId) {
        var totalCount = Number($(formId +' #total').val()) || 0;
        var limit = $(formId +' #size').val() || 5;
        var showCount = Number($(formId +' #showCount').val()) || 5;

        //向分页组件传递数据
        $(formId + ' #callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, total) {
                $(formId+" #current").val(curr);
                pager(formId);
            }
        });
    }

    /**
     * 查询分页数据
     * @param formId
     */
    function pager(formId){
        var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
        var url = baseUrl + "/wechat/venue/venueListPaper.json";
        var tpl = $("#venue-pageDetail-tpl").html();

        $.post(url,$(formId).serialize(),function(data){
            var r = new Array();
            if(data.data){
                r= data.data;
            }

            var html = juicer(tpl, {data:r});
            $(formId + " #pageDetail-c").html(html);
            $(formId + ' #total').val(data.totalCount);

            if( $(formId+" #current").val() =="1"){
                initPage(formId);
            }

            layer.close(loadIndex);
        })
    }

    function editVenue(venueId) {
        window.location.assign(baseUrl + "/wechat/venue/editVenue?venueId=" + venueId);
    }
</script>
</html>