<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>任务转交</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	function goBack() {
		window.location.assign(baseUrl + "/wechat/task/taskList/init");
	}


	function gotoPlanList() {
		window.location.assign(baseUrl + "/wechat/plan/planList/init?taskId=${surveyTask.oid}");
	}
	
	function submitForm() {
		var taskName = $("#taskName").val();
		var assginName = $("#assginId").find("option:selected").text();
		var assginId = $("#assginId").val();
		if (assginId == "") {
			layer.msg("请选择要转交的勘查人员！");
			return;
		}
		
		layer.confirm("<h5 class=\"text-center\"> 确定提交任务转交申请吗？提交后将由主管人 员进行审批！</h5>", {
			  title:"任务转交",
			  btn: ['确定','取消'] //按钮
			}, function(){
				var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/wechat/task/transferTask.json",
					data : $("#applyForm").serialize(),
					dataType : "json",
					// async : false,
					success : function(data) {
						layer.msg(data.message);
						if(data.status=="200"){
                            layer.close(loadIndex);
							layer.alert(data.message,{
								yes :function(){
									window.location.reload();//刷新当前页面.
								},
								cancel :function(){
									window.location.reload();//刷新当前页面.
								}
							});
						}else{
                            layer.close(loadIndex);
						}
					},error: function(){
						layer.close(loadIndex);
						layer.msg('系统发生未知错误，请联系管理员确认');
					}
				});
			}, function(){
			});
	}
	
	function showInputNum(obj, showId) {
		$("#" + showId).html(obj.value.length);
	}
	
</script>

</head>
<body>
	<c:choose>
		<c:when test="${surveyTask.surveyTaskStatus eq 'TRANSFERAUDIT' }">
			<div  class="container-fluid bg-6f pt-10">
				<div class="task-transfer clearfix">
					<div class="tatr-left"><label>活动名称：</label></div>
					<div class="tatr-right"><span>${surveyTask.name } </span></div>
				</div>
				<div class="task-transfer clearfix">
					<div class="tatr-left"><label>活动时间：</label></div>
					<div class="tatr-right"><span><fmt:formatDate value='${surveyTask.activityTime }' pattern='yyyy-MM-dd HH:mm:00' /></span></div>
				</div>
				<div class="task-transfer clearfix">
					<div class="tatr-left"><label>活动地点：</label></div>
					<div class="tatr-right"><span>${surveyTask.address }</span></div>
				</div>
				<div class="task-transfer clearfix">
					<div class="tatr-left"><label>转交人：</label></div>
					<div class="tatr-right"><span>${surveyAssist.accepter.realName }</span></div>
				</div> 
				<div class="task-transfer clearfix">
					<div class="tatr-left"><label>转交原因：</label></div>
					<div class="tatr-right"><span>${surveyAssist.reason }</span></div>
				</div>
				<div class="text-center submit-btn">
					<p class="btn bg-2e9fe3">审批中</p>
					<button type="button" class="btn btn-primary bg-2e9fe3" onclick="goBack();">返回</button>
				</div>
			</div> 
		</c:when>
		<c:otherwise>
			<form id="applyForm">
				<input type="hidden" name="surveyTask.oid" value="${ surveyTask.oid }">
				<input type="hidden" id="taskName" value="${ surveyTask.name }">
				<div  class="container-fluid bg-6f pt-10">
					<div class="task-transfer clearfix">
						<div class="tatr-left"><label>活动名称：</label></div>
						<div class="tatr-right"><span>${surveyTask.name } </span></div>
					</div>
					<div class="task-transfer clearfix">
						<div class="tatr-left"><label>活动时间：</label></div>
						<div class="tatr-right"><span><fmt:formatDate value='${surveyTask.activityTime }' pattern='yyyy-MM-dd HH:mm:00' /></span></div>
					</div>
					<div class="task-transfer clearfix">
						<div class="tatr-left"><label>活动地点：</label></div>
						<div class="tatr-right"><span>${surveyTask.address }</span></div>
					</div>
					<div class="task-transfer clearfix" >
						<div class="tatr-left"><label>转交人：</label></div>
						<div class="tatr-right">
							<span>
								<select name="accepter.oid" id="assginId" class="weui_select">
									<option value="">--请选择--</option>
									<c:forEach items="${userList }" var="user">
										<c:if test="${user.oid ne surveyTask.user.oid }">
											<option value="${user.oid }">${user.realName }</option>
										</c:if>
									</c:forEach>
								</select>
							</span>
						</div>
					</div> 
					<div class="task-transfer clearfix">
						<div class="tatr-left"><label>转交原因：</label></div>
						<div class="tatr-right"> 
							<div class="pos-rel">
								<textarea id="reason" name="reason" rows="10" placeholder="请输入您的转交原因" maxlength="200" oninput="showInputNum(this,'stat_total');"></textarea>
								<div class="gray"><span id="stat_total" class="b light">0</span>/<span id="stat_max" class="b ligh">200</span></div>
							</div>
								 
						</div> 
					</div>
					<div class="text-center submit-btn">
						<button type="button" class="btn btn-primary bg-2e9fe3" onclick="submitForm();">提交申请</button>
						<button type="button" class="btn btn-primary bg-2e9fe3" onclick="gotoPlanList();">返回</button>
					</div>
				</div>
			</form>
		</c:otherwise>
	</c:choose>
</body>

</html>

