<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>申请专家</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
</head>
<body>
	<form id="applyForm">
		<input type="hidden" name="surveyTask.oid" id="taskId" value="${ surveyTask.oid }">
		<input type="hidden" name="activityOid" id="activityOid" value="${ activityOid }">
		<input type="hidden" id="taskName" value="${ surveyTask.name }">
		<div  class="container-fluid bg-6f pt-10">
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>活动名称：</label></div>
				<div class="tatr-right"><span>${surveyTask.name }</span></div>
			</div>
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>活动时间：</label></div>
				<div class="tatr-right"><span><fmt:formatDate value='${surveyTask.activityTime }' pattern='yyyy-MM-dd HH:mm:00' /></span></div>
			</div>
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>活动地点：</label></div>
				<div class="tatr-right"><span>${surveyTask.address }</span></div>
			</div>
			<div class="task-transfer clearfix" >
				<div class="tatr-left"><label>勘查阶段：</label></div>
				<div class="tatr-right">
					<span>
						<select name="surveyStep" id="surveyStep">
							<c:forEach items="${stepList }" var="surveyStep">
								<option value="${surveyStep }">${surveyStep.name}</option>
							</c:forEach>
						</select>
					</span>
				</div>
			</div> 
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>选择专家：</label><br/><strong style="color: #999999;font-weight: normal;">(可多选)</strong></div>
				<div style="float:left">
					<ul>
						<c:forEach items="${expertList }" var="expert">	
						<li >
							<%--<p class="img-pick"><img src="<c:url value='/resources/wechat2/images/pick-btn.jpg'/>" width="20" height="20"></p>--%>
							<input type="checkbox" value="${expert.oid }" name="specialists" />${expert.realName } ${expert.phone }
						</li>
						</c:forEach>
						<input type="hidden" id="experts" name="experts"/>
					</ul>
					
				</div>
			</div> 
					
			<div class="task-transfer clearfix">
				<div class="tatr-left"><label>申请原因：</label></div>
				<div class="tatr-right"> 
					<div class="pos-rel">
						<textarea id="reason" name="reason" oninput="showInputNum(this,'stat_total');" maxlength="200" rows="10" placeholder="请输入您的申请原因" ></textarea>
						<div class="gray"><span id="stat_total" class="b light">0</span>/<span id="stat_max" class="b ligh">200</span></div>
					</div>
 					 
				</div> 
			</div>
			<div class="text-center submit-btn">
				<button type="button" class="btn btn-primary bg-2e9fe3" onclick="submitForm();">提交申请</button>
				<button type="button" class="btn btn-primary bg-2e9fe3" onclick="gotoPlanList();">返回</button>
			</div>
		</div> 
	</form>
</body>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	$(function() {
        // 为 class = pick-on 的控件绑定 click 事件
        $(".pick-on").click(function() {
            // 使用 toggleClass ，如果 class 中没有 pick-out 则附加上，有则减掉
            $(this).toggleClass("pick-out"); 
            if($(this).hasClass("pick-out")){
            	$('.pick-on input').removeAttr('checked'); 
        		$($('.pick-on input').eq(0)).prop('checked',true);
            }else{
            	$('.pick-on input').removeAttr('checked'); 
        		$($('.pick-on input').eq(0)).prop('checked',false);
            }
        })
    })
	
	function wechatCloseForm() {
		WeixinJSBridge.call('closeWindow');
	}

	function goBack(){
		var taskId = $("#taskId").val();
		window.location.assign(baseUrl + "/wechat/plan/planList/init?taskId="+taskId);
	}

	function gotoPlanList() {
		window.location.assign(baseUrl + "/wechat/plan/planList/init?taskId=${surveyTask.oid}");
	}
	
	function jqchk(){ //jquery获取复选框值 
		var chk_value =[]; 
		$('input[name="test"]:checked').each(function(){ 
		chk_value.push($(this).val()); 
		}); 
		alert(chk_value.length==0 ?'你还没有选择任何内容！':chk_value); 
		} 
	
	function submitForm() {
		var chk_value =[];
        $("#experts").val("");
		var experts = $("#experts").val();
		$('input[name="specialists"]:checked').each(function(){ 
			chk_value.push($(this).val());
            experts = experts + "#" + $(this).val();
		}); 
		if(chk_value.length<1){
			layer.msg("请选择专家！");
			return;
		}
        $("#experts").val(experts);
		var reason = $("#reason").val();
		if (reason == "") {
			layer.msg("请填写申请原因！");
			return;
		}
		var taskName = $("#taskName").val();
		var stepName = $("#surveyStep").find("option:selected").text();
		layer.confirm("确定提交专家申请吗？提交后将由主管人员进行审批！", {
			  btn: ['确定','取消'] //按钮
			}, function(){
				var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/wechat/task/applyExpert.json",
					data : $("#applyForm").serialize(),
					dataType : "json",
					//async :false,
					success : function(data) {
						layer.close(loadIndex);
						layer.msg(data.message);
						if(data.status =="200"){
							var taskId = $("#taskId").val();
							setTimeout("goBack()",2000);
						}
					},error: function(){
						layer.close(loadIndex);
						layer.msg('系统发生未知错误，请联系管理员确认');
					}
				});
			}, function(){
			});
	}

	function showInputNum(obj, showId) {
		$("#" + showId).html(obj.value.length);
	}
</script>

</html>

