<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>勘查详情</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/wechat2/dist/css/survey-ques.css?v=${version}'/>" />
</head>
<body>
	<div class="container-fluid bg-6f pt-10" id="top">
			<div class="issue-title text-center">
				<h4>${surveyPlan.surveyTask.name }</h4>
				<p>第${surveyPlan.time }次勘查 ${surveyPlan.surveyStep.name } ${surveyPlan.venue.name }</p>
			</div>
		</div> 
		<c:set var="questionIndex" value="1" />
		<div class="issue-content">
			<div class="isscon-title"><h4>固定问题</h4></div>
			<c:forEach items="${surveyInfoList }" var="surveyInfo">
				<c:if test="${surveyInfo.questionType eq 'FIXED' }">
			<div class="issue-consub">
				<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
				<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
				<c:if test="${ not empty surveyInfo.photos }">
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</c:if>
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>			
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>遗留问题</h4></div>
			<c:forEach items="${surveyInfoList }" var="surveyInfo">
			<c:if test="${surveyInfo.questionType eq 'CARRYOVER' }">
			<div class="issue-consub">
				<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
				<h6>上次勘查结果：</h6>
				<p>${surveyInfo.answer }</p> 
			</div>
			<c:if test="${ not empty surveyInfo.lastSurvey.photos }">
			<div class="issue-consub"> 
				<h6>上次勘查图片：</h6>
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.lastSurvey.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</div>
				</c:if>
				
			<div class="issue-consub">
				<h6>承办方整改情况：</h6>
				<p>${surveyInfo.lastSurvey.surveyReform.result }</p>
				<div class="changes clearfix">
					${surveyInfo.nextSurvey ? '<span class="bg-f98718">未整改</span>':'<span class="bg-49a61a">已整改</span>' }
				</div>
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${surveyInfo.photos }" var="photo">
						<li class="portrait">
							<img  onclick="preViewImg('${photo.path}');" src="${photo.path}" class="pic"/>
						</li>
						</c:forEach>
					</ul>
				</div> 
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>开放问题</h4></div> 
			<c:forEach items="${surveyInfoList }" var="surveyInfo">
				<c:if test="${surveyInfo.questionType eq 'UNFIXED' }">
			<div class="issue-consub">
				<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
				<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
				<c:if test="${ not empty surveyInfo.photos }">
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</c:if>
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>补充问题</h4></div> 
			<c:forEach items="${surveyInfoList }" var="surveyInfo">
				<c:if test="${surveyInfo.questionType eq 'SUPPLEMENT' }">
			<div class="issue-consub">
				<h5 class="hand-down clearfix">${questionIndex}、${surveyInfo.question }</h5>
				<c:if test="${ not empty surveyInfo.answer }"><p>${surveyInfo.answer }</p></c:if>
				<c:if test="${ not empty surveyInfo.photos }">
				<div class="list-img clearfix">
					<ul>
						<c:forEach items="${ surveyInfo.photos }" var="photo">
						<li class="portrait">
							<img class="pic" src="${photo.path }" onclick="preViewImg('${photo.path}');"/>
						</li>
						</c:forEach>
					</ul>
				</div>
				</c:if>
			</div>
			<c:set var="questionIndex" value="${questionIndex+1 }" />
			</c:if>
			</c:forEach>
			<div class="text-center submit-btn">
				<input id="questionnaireId" value="${questionnaire.oid }" type="hidden"/>
				<input id="questionIndex" value="${questionIndex }" type="hidden"/>
<!-- 				<a href="javascript:editAnswer('0','0','新增问题');" class="btn btn-primary bg-2e9fe3" id="bottom">新增问题</a> -->
				<a href="<c:url value='/wechat/question/questionList/init/${surveyPlan.surveyTask.oid }'/>" class="btn btn-primary bg-2e9fe3" id="bottom">返回</a>
			</div>
		</div>
</body>
<script type="text/javascript" src="https://res.wx.qq.com/open/js/jweixin-1.2.0.js?v=${version}"></script>
<script src="<c:url value='/resources/commonJS/wechat/wechat.js?v=${version}'/>" type="text/javascript"></script>
<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
var canMove = true;
var surveyView = true;
document.addEventListener('touchmove', function (event){
	if(!canMove)
		event.preventDefault();
});
wx.config({
	debug : false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
	appId : '${appid}', // 必填，公众号的唯一标识
	timestamp : '${timestamp}', // 必填，生成签名的时间戳
	nonceStr : '${noncestr}', // 必填，生成签名的随机串
	signature : '${sign}',// 必填，签名，见附录1
	jsApiList : [ 'closeWindow', 'chooseImage', 'previewImage', 'uploadImage' ]
// 必填，需要使用的JS接口列表，所有JS接口列表见附录2
});

wx.ready(function() {
	//判断当前客户端版本是否支持指定JS接口
	wx.checkJsApi({
		jsApiList : [ 'chooseImage' ], // 需要检测的JS接口列表，所有JS接口列表见附录2,
		success : function(res) {
			// 以键值对的形式返回，可用的api值true，不可用为false
			// 如：{"checkResult":{"chooseImage":true},"errMsg":"checkJsApi:ok"}
		}
	});
	//隐藏右上角菜单接口
	wx.hideOptionMenu();
	
});

function editAnswer(questionIndex,questionId,questionTypeName){
	if(questionIndex == 0 || questionIndex == "0")
		questionIndex = $("#questionIndex").val();
	$("body").addClass("unoverflow");
	$("#modal").remove();
	$(obj).d_modal({
        title: questionTypeName,
        cssclass:'modal-blue modal-mid',
        content: "loading....",
        cache:false,
        remote: baseUrl + '/wechat/survey/editAnswer/init?questionIndex='+questionIndex+'&questionId='+questionId
    });
}

function reloadPage(){
	window.location.reload();//刷新当前页面.
}
</script>
</html>