<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<c:choose>
	<c:when test="${lastSurveyComplete eq false }">
		<div class="text-center submit-btn">
		<a href="javascript:void(0);" >前一次勘查未完成</a>
		</div>
	</c:when>
	<c:when test="${questionnaire.taskStatus.getKey() eq 'CLOSE' ||questionnaire.taskStatus.getKey() eq 'COMPLETE' }">
	<div class="text-center submit-btn">
		<a href="javascript:void(0);">勘查任务已关闭</a>
		</div>
	</c:when>
	<c:when test="${questionnaire.generate eq false }">
	<div class="text-center submit-btn">
		<a href="javascript:void(0);">勘查问卷未维护</a>
		<a href="<c:url value='/wechat/question/questionList/init/${surveyPlan.surveyTask.oid }'/>" class="btn btn-primary bg-2e9fe3">立即维护</a>
	</div>
	</c:when>
	<c:otherwise>
		<input type="hidden" value="${questionnaire.oid }" name="questionnaireId" id="questionnaireId" />
		<input type="hidden" value="${surveyPlan.oid }" name="planId" id="planId" />
		<c:set var="editable" value="${questionnaire.taskStatus.getKey() ne 'COMPLETE' && questionnaire.taskStatus.getKey() ne 'CLOSE'}" />
		
		<c:set var="questionIndex" value="1" />
		<div class="issue-content">
			<div class="isscon-title"><h4>固定问题</h4></div>
			<div class="issueslist-war bonone">
				<c:forEach items="${questionnaire.surveyInfos }" var="surveyInfo">
					<c:if test="${surveyInfo.questionType eq 'FIXED' }">
						<div class="issueslist-sub clearfix" onclick="editAnswer('${questionIndex}','${surveyInfo.oid}','${surveyInfo.questionType.name }',this);">
							<input type="checkbox" style="display: none;" disabled="disabled" name="finishFixedAnswers" id="finishAnswer${surveyInfo.oid }" ${surveyInfo.replied ? "checked=checked":"" }>
							<div class="issueslistsub">
								<div class="ilsubleft">${questionIndex}、${surveyInfo.question }</div>
								<div class="ilsubright" id="disabled${surveyInfo.oid }">
									<c:choose>
										<c:when test="${surveyInfo.replied }">
											<img src="<c:url value='/resources/wechat2/images/tick.jpg'/>" width="20" height="16">
										</c:when>
										<c:otherwise>
											<img src="<c:url value='/resources/wechat2/images/sign.jpg'/>"  width="13" height="22">
										</c:otherwise>
									</c:choose>
								</div>
							</div> 
						</div>
						<c:set var="questionIndex" value="${questionIndex+1 }" />
					</c:if>
				</c:forEach>
			</div>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>遗留问题</h4></div>
			<div class="issueslist-war bonone">
				<c:forEach items="${questionnaire.surveyInfos }" var="surveyInfo">
					<c:if test="${surveyInfo.questionType eq 'CARRYOVER' }">
						<div class="issueslist-sub clearfix" onclick="editAnswer('${questionIndex}','${surveyInfo.oid}','${surveyInfo.questionType.name }',this);">
							<input type="checkbox" style="display: none;" disabled="disabled" name="finishAnswers" id="finishAnswer${surveyInfo.oid }" ${surveyInfo.replied ? "checked=checked":"" }>
							<div class="issueslistsub">
								<div class="ilsubleft">${questionIndex}、${surveyInfo.question }</div>
									<div class="ilsubright" id="disabled${surveyInfo.oid }">
										<c:choose>
											<c:when test="${surveyInfo.replied }">
												<img src="<c:url value='/resources/wechat2/images/tick.jpg'/>" width="20" height="16">
											</c:when>
											<c:otherwise>
												<img src="<c:url value='/resources/wechat2/images/sign.jpg'/>"  width="13" height="22">
											</c:otherwise>
										</c:choose>
									</div>
							</div> 
						</div>
						<c:set var="questionIndex" value="${questionIndex+1 }" />
					</c:if>
				</c:forEach>
			</div>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>开放问题</h4></div>
			<div class="issueslist-war bonone">
				<c:forEach items="${questionnaire.surveyInfos }" var="surveyInfo">
					<c:if test="${surveyInfo.questionType eq 'UNFIXED' }">
						<div class="issueslist-sub clearfix" onclick="editAnswer('${questionIndex}','${surveyInfo.oid}','${surveyInfo.questionType.name }',this);">
							<div class="issueslistsub">
								<div class="ilsubleft">${questionIndex}、${surveyInfo.question }</div>
								<div class="ilsubright" id="disabled${surveyInfo.oid }">
									<c:choose>
										<c:when test="${surveyInfo.replied }">
											<img src="<c:url value='/resources/wechat2/images/tick.jpg'/>" width="20" height="16">
										</c:when>
										<c:otherwise>
											<img src="<c:url value='/resources/wechat2/images/sign.jpg'/>"  width="13" height="22">
										</c:otherwise>
									</c:choose>
								</div>
							</div> 
						</div>
						<c:set var="questionIndex" value="${questionIndex+1 }" />
					</c:if>
				</c:forEach>
			</div>
		</div>
		<div class="issue-content">
			<div class="isscon-title"><h4>补充问题</h4></div> 
			<div class="issueslist-war" id="supplementArea">
				<c:forEach items="${questionnaire.surveyInfos }" var="surveyInfo" varStatus="status">
					<c:if test="${surveyInfo.questionType eq 'SUPPLEMENT' }">
					<div class="issueslist-sub clearfix" id="question${surveyInfo.oid}" onclick="editAnswer('${questionIndex}','${surveyInfo.oid}','${surveyInfo.questionType.name }',this);">
						<div class="issueslistsub">
							<div class="ilsubleft">
								<span>${questionIndex}、${surveyInfo.question }</span>
								<span onclick="event.cancelBubble = true">
								<img src="<c:url value='/resources/wechat2/images/delete-issue.jpg'/>" width="22" height="22" onclick="removeQuestion('${surveyInfo.oid}');">
								</span>
							</div>
							<div class="ilsubright" id="disabled${surveyInfo.oid }">
								<c:choose>
									<c:when test="${surveyInfo.replied }">
										<img src="<c:url value='/resources/wechat2/images/tick.jpg'/>" width="20" height="16">
									</c:when>
									<c:otherwise>
										<img src="<c:url value='/resources/wechat2/images/sign.jpg'/>"  width="13" height="22">
									</c:otherwise>
								</c:choose>
							</div>
						</div> 
					</div>
					<c:set var="questionIndex" value="${questionIndex+1 }" />
					</c:if>
				</c:forEach>		
			</div>
			<div class="text-center submit-btn">
				<input id="questionIndex" value="${questionIndex }" type="hidden"/>
				<a href="javascript:void(0);" onclick="editAnswer('0','0','新增问题',this);" class="btn btn-primary bg-2e9fe3" id="bottom">新增问题</a> 
			</div>
		</div>
		<div class="issue-content"> 
			<div class="issueslist-war bonone">
				<div class="issueslist-sub clearfix">
					<div class="issueslistsub">
						<div class="ilsubleft">
							<span>勘查人员签到:</span>
							<span class="sign-in" onclick="getMyLocationAndSign();" ${surveyPlan.sign ?"style='display:none;'":""  }>签到</span>
							<span class="end-sign-in" ${surveyPlan.sign ?"":"style='display:none;'"  }>已签到</span>
						</div> 
					</div> 
				</div>
				<div class="issueslist-sub clearfix">
					<div class="issueslistsub">
						<div class="ilsubleft">
						<span>承&nbsp;办&nbsp;方&nbsp;签&nbsp;名:</span>
							<span class="signature" onclick="showSign('1');" id="purveyorSignBtn">签名</span>
							<span class="signatureimg" onclick="showSign('1');" id="purveyorSignImgArea" style="display: none;"><img src="" id="purveyorSignImg"></span>
						</div> 
					</div> 
				</div>
				<div class="issueslist-sub clearfix">
					<div class="issueslistsub">
						<div class="ilsubleft">
							<span>勘查人员签名:</span>
							<span class="signature" onclick="showSign('2');" id="signBtn">签名</span>
							<span class="signatureimg" onclick="showSign('2');" id="signImgArea" style="display: none;"><img src="" id="signImg"></span>
						</div> 
					</div> 
				</div>
			</div> 
		</div> 
		<div class="text-center submit-btn">
			<button type="button" id="submitSurveyButton" class="btn btn-primary bg-2e9fe3" onclick="finishSurvey();" >提交勘查结果</button>
		</div>
	</c:otherwise>
</c:choose>
<script>
	var newQuestionId = 1;
	var nowSign = 1;
	
	function editAnswer(questionIndex,questionId,questionTypeName,obj){
		if(questionIndex == 0 || questionIndex == "0"){
			questionIndex = $("#questionIndex").val();
		}
		$("body").addClass("unoverflow");
        $("#modal").remove();
		$(obj).d_modal({
            title: questionTypeName,
            cssclass:'modal-blue modal-mid',
            content: "loading....",
            cache:false,
            remote: baseUrl + '/wechat/survey/editAnswer/init?questionIndex='+questionIndex+'&questionId='+questionId
        });
	}
	
	function showSign(signId){
		nowSign = signId;
		var title="勘查人员签名";
		if(nowSign == "1")
			title="承办方签名"
		layer.open({
			  type: 2,
			  title: title,
			  closeBtn: 0,
			  shadeClose: false,
			  scrollbar: false,
			  area: ['100%', '100%'],
			  content: baseUrl + '/wechat/survey/showSign'
		});
	}
	
	function getSignature(dataUrl){
		if (nowSign == "1") {
			$("#purveyorSignPath").val(dataUrl);
			$("#purveyorSignImg").attr('src', dataUrl);
			$("#purveyorSignBtn").hide();
			$("#purveyorSignImgArea").show();
		} else {
			$("#signBtn").hide();
			$("#signImgArea").show();
			$("#signImg").attr('src', dataUrl);
			$("#signImgPath").val(dataUrl);
		}
	}
</script>
