<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>勘查问卷</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/extendPagination.js?v=${version}'/>"></script>
</head>
<body>
<div style="display:flex; height:50px; line-height:50px;background:#FFF;border-bottom:1px solid #DDD;"  onclick="javascript:location.href='/wechat/index?_check=2'">
	<div style="width:5%;font-size:18px; padding-left:15px;">   <   </div>
	<div style="width:95%; text-align:center; text-indent:-10px; font-size:18px;">   勘查问卷   </div>
</div>
	<div class="tab-content nmt10">
		<table class="table">
			<thead>
				<tr>
					<th>活动名称</th>
					<th>活动时间</th>
					<th>活动地点</th>
					<th>联系人</th>
					<th>状态</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody id="taskList">
				<c:if test="${not empty taskList }">
					<c:forEach items="${taskList }" var="surveyTask">
						<tr>
							<td>${surveyTask.name }</td>
							<td><fmt:formatDate value='${surveyTask.activityTime }' pattern='yyyy-MM-dd HH:mm' /><br>-<br><fmt:formatDate value='${surveyTask.endTime }' pattern='yyyy-MM-dd HH:mm' /></td>
							<td>${surveyTask.address }&nbsp;</td>
							<td>${surveyTask.contacts }<br />${surveyTask.contactMobile }</td>
							<td>${surveyTask.surveyTaskStatus.name }</td>
							<td>
								<c:if test="${surveyTask.surveyTaskStatus eq 'RECEIVE' || surveyTask.surveyTaskStatus eq 'DOING'}">
									<a href="javascript:createQuestion('${surveyTask.oid }');">问卷设计</a>
								</c:if>
								<c:if test="${surveyTask.surveyTaskStatus eq 'OBSOLETE' || surveyTask.surveyTaskStatus eq 'DONE' }">
									<a href="javascript:createQuestion('${surveyTask.oid }');">查看详情</a>
								</c:if>
							</td>
						</tr>
					</c:forEach>
				</c:if>
				<c:if test="${empty taskList }">
					<tr>
						<td colspan="6" class="text-center">无相关数据</td>
					</tr>
				</c:if>
			</tbody>
		</table>
		<form id="taskForm">
			<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
			<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
			<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
			<c:if test="${not empty taskList }">
			<div id="callBackPager" style="margin: 0 auto; text-align: center;"></div>
			</c:if>
		</form>
	</div>
	
</body>
<script type="text/javascript">
	
	var baseUrl = '${pageContext.request.contextPath }';
	
	function wechatCloseForm() {
		WeixinJSBridge.call('closeWindow');
	}
	
	function createQuestion(taskId) {
		window.location.assign(baseUrl + "/wechat/question/questionList/init/" + taskId);
	}
	
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 10;
	$('#callBackPager').extendPagination({
		totalCount : totalCount,
		showCount : showCount,
		limit : limit,
		callback : function(curr, limit, totalCount) {
			getListForPage("taskForm", "taskList");
		}
	});
	function getListForPage(formId, contentId) {
		var loadIndex = layer.load(0, {
			shade : [ 0.3, '#808080' ]
		});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/wechat/question/gettaskListForPage",
			data : $("#" + formId).serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(loadIndex);
				$("#" + contentId).html(data);
			},
			error : function() {
				layer.close(loadIndex);
			}
		});
	}
</script>
</html>

