<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>问卷维护</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wechat2/dist/css/survey-ques.css?v=${version}" />
	
</head>
<body>
<c:choose>
	<c:when test="${lastSurveyComplete eq false }">
		<div class="text-center submit-btn">
			<a>前一次勘查未完成</a>
			<a href="<c:url value='/wechat/question/questionList/init/${surveyPlan.surveyTask.oid }'/>" class="btn btn-primary bg-2e9fe3">返回</a>
		</div>
	</c:when>
	<c:when test="${questionnaire.taskStatus.getKey() eq 'CLOSE' ||questionnaire.taskStatus.getKey() eq 'COMPLETE' }">
		<div class="text-center submit-btn">
			<a>勘查任务已关闭</a>
			<a href="<c:url value='/wechat/question/questionList/init/${surveyPlan.surveyTask.oid }'/>" class="btn btn-primary bg-2e9fe3">返回</a>
		</div>
	</c:when>
	<c:otherwise>
	<form id="queryForm">
		<input type="hidden" id="planId" value="${surveyPlan.oid }">
		<input type="hidden" id="questionnaireId" name="questionnaireId" value="${questionnaire.oid }">
	<div class="container-fluid bg-6f pt-10">
		<div class="issue-title text-center">
			<h4>${surveyPlan.surveyTask.name }</h4>
			<p>第${surveyPlan.time }次勘查 ${surveyPlan.surveyStep.name } ${surveyPlan.venue.name }</p>
		</div>
	</div>
	<div id="fixedArea" class="choosable_war browse_war">
	<div class="issue-content">
		<div class="isscon-title"><h4>固定问题</h4></div>
		<c:set var="fixQuestionSize" value="0"/>
		<c:forEach items="${surveyInfoList }" var="surveyInfo">
		<c:if test="${surveyInfo.questionType eq 'FIXED' }">
		<c:set var="fixQuestionSize" value="${fixQuestionSize +1 }"/>
		<div class="issue-consub">
			<h5>${fixQuestionSize }. ${surveyInfo.question }</h5>
			<p>${surveyInfo.answerTip }</p>
		</div>
		</c:if>
		</c:forEach>
	</div>
	<div class="text-center submit-btn">
		<a href="javascript:nextOption('${questionnaire.oid }');" class="btn btn-primary bg-2e9fe3">下一步</a>
	</div>
	</div>
	<div id="optionalArea" style="display: none;"></div>
	</form>
	</c:otherwise>
</c:choose>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/wechat.js?v=${version}'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/createQuestion.js?v=${version}'/>"></script>
	<script type="text/javascript" src="https://res.wx.qq.com/open/js/jweixin-1.2.0.js"></script>
</body>
<script>
	var baseUrl = '${pageContext.request.contextPath }';
	
	wx.config({
		debug : false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
		appId : '${appid}', // 必填，公众号的唯一标识
		timestamp : '${timestamp}', // 必填，生成签名的时间戳
		nonceStr : '${noncestr}', // 必填，生成签名的随机串
		signature : '${sign}',// 必填，签名，见附录1
		jsApiList : [ 'closeWindow', 'chooseImage', 'previewImage', 'uploadImage' ]
	// 必填，需要使用的JS接口列表，所有JS接口列表见附录2
	});

	wx.ready(function() {
		//判断当前客户端版本是否支持指定JS接口
		wx.checkJsApi({
			jsApiList : [ 'chooseImage' ], // 需要检测的JS接口列表，所有JS接口列表见附录2,
			success : function(res) {
				// 以键值对的形式返回，可用的api值true，不可用为false
				// 如：{"checkResult":{"chooseImage":true},"errMsg":"checkJsApi:ok"}
			}
		});
		//隐藏右上角菜单接口
		wx.hideOptionMenu();
	});
</script>
</html>

