<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>

<head>
	<%@include file="/WEB-INF/views/include/head.jsp" %>
	<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>

<body class="gray-bg">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-sm-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-content">
                        <table id="dataTable"></table>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
	<script>
		$(function(){
			var objId = "dataTable";
			var url = ctx + "/manage/survey/findAssistListForPage.json";
			var columns = [  
					 {title: 'id',field: 'id', visible: false, align: 'center',valign: 'middle'},     
					 {title: '活动名称',field: 'surveyTask',align: 'center',valign: 'middle',sortable: true},   
					 {title: '协助类型',field: 'assignType',align: 'center',valign: 'middle',sortable: true},  
					 {title: '申请人',field: 'user', align: 'center',valign: 'middle',sortable: true},  
					 {title: '申请原因',field: 'reason',align: 'center',valign: 'middle',sortable: true},    
					 {title: '分配状态',field: 'assignStatus',align: 'center',valign: 'middle',sortable: true},  
					 {title: '申请时间',field: 'createOn',align: 'center',valign: 'middle',sortable: true},  
					 {title: '操作',field: '#',align: 'center',  
					     formatter:function(value,row,index){    
					         var d = "";
					         if(row.assignStatusValue =="NON"){
					       	 	d = '<a class="btn btn-primary" href="'+ctx+'/manage/survey/approvalAssist/'+row.id+'" target="dialog" width="960px" height="600px"><i class="fa fa-edit"></i>审批</a>';
					         }
					         return d;    
					     }   
					 }  
					];
			bootstrapTableDiy(objId,url,columns);

			initLayerBtnClick();
		})
	</script>

</body>
</html>
