<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>PSS勘查后台管理系统</title>
	<%@include file="/WEB-INF/views/include/head.jsp"%>
</head>

<body class="fixed-sidebar full-height-layout gray-bg" style="overflow:hidden">
    <div id="wrapper">
        <!--左侧导航开始-->
        <nav class="navbar-default navbar-static-side" role="navigation">
            <div class="nav-close"><i class="fa fa-times-circle"></i>
            </div>
			<div class="sidebar-collapse">
				<ul class="nav" id="side-menu">
					<li class="nav-header">
						<div class="dropdown profile-element">
<%-- 							 <span><img alt="image" class="img-circle" src="${ctxStatic }/img/logo.jpg" style="height: 80px;"/></span> --%>
							<a data-toggle="dropdown" class="dropdown-toggle" href="#"> 
							<span class="clear"></span> 
							<span class="block m-t-xs"><strong class="font-bold">
								&nbsp;&nbsp;&nbsp;<sec:authentication property="principal.username" /></strong>
							</span>
							</a>
						</div>
						<div class="logo-element">PSS</div>
					</li>
					<sec:authorize ifAnyGranted="ROLE_ADMIN">
					<li>
						<a href="#"> 
							<i class="fa fa-user"></i>
							<span class="nav-label">勘查报告管理</span> <span class="fa arrow"></span>
						</a>
						<ul class="nav nav-second-level">
							<li><a id="reportList" class="J_menuItem" href="<c:url value='/manage/surveyReport/reportList/init'/>"><i class="fa fa-users"></i>勘查报告列表</a></li>
						</ul>
					</li>
					</sec:authorize>
					<sec:authorize ifAnyGranted="PM">
					<li>
						<a href="#"> 
							<i class="fa fa-folder"></i>
							<span class="nav-label">项目管理</span> <span class="fa arrow"></span>
						</a>
						<ul class="nav nav-second-level">
							<li><a id="taskList" class="J_menuItem" href="<c:url value='/manage/task/taskList/init'/>"><i class="fa fa-file"></i>任务分配</a></li>
							<li><a id="assistList" class="J_menuItem" href="<c:url value='/manage/survey/assistList/init'/>"><i class="fa fa-file"></i>勘查协助管理</a></li>
						</ul>
					</li>
					</sec:authorize>
				</ul>
			</div>
		</nav>
        <!--左侧导航结束-->
        <!--右侧部分开始-->
        <div id="page-wrapper" class="gray-bg dashbard-1">
            <div class="row border-bottom">
                <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
                    <div class="navbar-header"><a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
                    </div>
                    <ul class="nav navbar-top-links navbar-right">
                        <li class="dropdown hidden-xs">
                            <a class="right-sidebar-toggle" aria-expanded="false">
                                <i class="fa fa-tasks"></i> 主题
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <div class="row content-tabs">
                <button class="roll-nav roll-left J_tabLeft"><i class="fa fa-backward"></i>
                </button>
                <nav class="page-tabs J_menuTabs">
                    <div class="page-tabs-content">
                        <a href="javascript:;" class="active J_menuTab" data-id="index_v1.html">首页</a>
                    </div>
                </nav>
                <button class="roll-nav roll-right J_tabRight"><i class="fa fa-forward"></i>
                </button>
                <div class="btn-group roll-nav roll-right">
                    <button class="dropdown J_tabClose" data-toggle="dropdown">关闭操作<span class="caret"></span>

                    </button>
                    <ul role="menu" class="dropdown-menu dropdown-menu-right">
                        <li class="J_tabShowActive"><a>定位当前选项卡</a>
                        </li>
                        <li class="divider"></li>
                        <li class="J_tabCloseAll"><a>关闭全部选项卡</a>
                        </li>
                        <li class="J_tabCloseOther"><a>关闭其他选项卡</a>
                        </li>
                    </ul>
                </div>
                <a href="${ctx}/j_spring_security_logout" class="roll-nav roll-right J_tabExit"><i class="fa fa fa-sign-out"></i> 退出</a>
            </div>
            <div class="row J_mainContent" id="content-main">
                <iframe class="J_iframe" name="iframe0" width="100%" height="100%" src="" frameborder="0" data-id="" seamless></iframe>
            </div>
            <div class="footer">
                <div class="pull-right">平台运营与技术支持 © 2017 百川信</a>
                </div>
            </div>
        </div>
        <!--右侧部分结束-->
        <!--右侧边栏开始-->
        <div id="right-sidebar">
            <div class="sidebar-container">

                <ul class="nav nav-tabs navs-3">

                    <li class="active"><a data-toggle="tab" href="#tab-1"><i class="fa fa-gear"></i>主题</a></li>
<!--                     <li class=""><a data-toggle="tab" href="#tab-2">通知</a></li> -->
<!--                     <li><a data-toggle="tab" href="#tab-3">项目进度</a></li> -->
                </ul>

                <div class="tab-content">
                    <div id="tab-1" class="tab-pane active">
                        <div class="sidebar-title">
                            <h3> <i class="fa fa-comments-o"></i> 主题设置</h3>
                            <small><i class="fa fa-tim"></i> 你可以从这里选择和预览主题的布局和样式，这些设置会被保存在本地，下次打开的时候会直接应用这些设置。</small>
                        </div>
                        <div class="skin-setttings">
                            <div class="title">主题设置</div>
                            <div class="setings-item">
                                <span>收起左侧菜单</span>
                                <div class="switch">
                                    <div class="onoffswitch">
                                        <input type="checkbox" name="collapsemenu" class="onoffswitch-checkbox" id="collapsemenu">
                                        <label class="onoffswitch-label" for="collapsemenu">
                                            <span class="onoffswitch-inner"></span>
                                            <span class="onoffswitch-switch"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="setings-item">
                                <span>固定顶部</span>

                                <div class="switch">
                                    <div class="onoffswitch">
                                        <input type="checkbox" name="fixednavbar" class="onoffswitch-checkbox" id="fixednavbar">
                                        <label class="onoffswitch-label" for="fixednavbar">
                                            <span class="onoffswitch-inner"></span>
                                            <span class="onoffswitch-switch"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="setings-item">
                                <span>固定宽度</span>
                                <div class="switch">
                                    <div class="onoffswitch">
                                        <input type="checkbox" name="boxedlayout" class="onoffswitch-checkbox" id="boxedlayout">
                                        <label class="onoffswitch-label" for="boxedlayout">
                                            <span class="onoffswitch-inner"></span>
                                            <span class="onoffswitch-switch"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="title">皮肤选择</div>
                            <div class="setings-item default-skin nb">
                                <span class="skin-name "><a href="#" class="s-skin-0">默认皮肤</a></span>
                            </div>
                            <div class="setings-item blue-skin nb">
                                <span class="skin-name "><a href="#" class="s-skin-1">蓝色主题</a></span>
                            </div>
                            <div class="setings-item yellow-skin nb">
                                <span class="skin-name "><a href="#" class="s-skin-3">黄色/紫色主题</a></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<%@include file="/WEB-INF/views/include/foot.jsp" %>
    <script src="${ctxStatic }/js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="${ctxStatic }/js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    <script src="${ctxStatic }/js/hplus.min.js?v=4.1.0"></script>
    <script type="text/javascript" src="${ctxStatic }/js/contabs.min.js"></script>
    <script src="${ctxStatic }/js/plugins/pace/pace.min.js"></script>
</body>
</html>
