<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>编辑场馆</title>
<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/wechat2/dist/css/survey-ques.css?v=${version}'/>" />
<script type="text/javascript" src="<c:url value='/resources/js/plugins/layer/laydate/laydatenew.js?v=${version}'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js?v=${version}'/>"></script>
<script type="text/javascript" src="https://res.wx.qq.com/open/js/jweixin-1.2.0.js?v=${version}"></script>
</head>
<body>
	<form id="venueForm">
		<input type="hidden" value="${venueId }" id="venueId" name="oid">
		<input type="hidden" value="${venueType }" name="venueType">
		<div class="container-fluid bg-6f pt-10" style="padding-bottom: 15px;">
			<div class="task-transfer clearfix">
				<div class="tatr-left">
					<label>场馆类型 :</label>
				</div>
				<div class="tatr-right">
					<span>
						${venueType eq '1'?"体育场馆":""}
						${venueType eq '2'?"展览馆":""}
						${venueType eq '3'?"室外场地":""}
						${venueType eq '4'?"展厅":""}
					</span>
				</div>
			</div>
			<c:if test="${venueType eq '4' }">
				<div class="task-transfer clearfix">
					<div class="tatr-left">
						<label><strong>*</strong>所属展馆：</label>
					</div>
					<div class="tatr-right">
						<span>
							<select id="parentVenueId" name="parentId" title="所属展馆">
								<option value=""> --请选择-- </option>
								<c:forEach items="${exhibitionList}" var="exhibition">
									<option value="${exhibition.oid}" ${venue.oid eq exhibition.oid ? "selected=selected":""}>${exhibition.name}</option>
								</c:forEach>
							</select>
						</span>
					</div>
				</div>
			</c:if>
			<c:forEach items="${venueList }" var="venueInputType" varStatus="venueStatus">
				<c:choose>
					<c:when test="${venueInputType.fieldName eq 'province'}">
						<div class="task-transfer clearfix">
							<div class="tatr-left">
								<label><strong>*</strong>${venueInputType.itemName }：</label>
							</div>
							<div class="tatr-right">
								<span> 
									<input type="hidden" id="id_provOld" value="${venueInputType.value }" />
									<select name="${venueInputType.fieldName }" id="id_provSelect" onchange="initCityRegion()">
										<option value=''>请选择省份</option>
									</select>
								</span>
							</div>
						</div>
					</c:when>
					<c:when test="${venueInputType.fieldName eq 'city'}">
						<div class="task-transfer clearfix">
							<div class="tatr-left">
								<label><strong>*</strong>${venueInputType.itemName }：</label>
							</div>
							<div class="tatr-right">
								<span> 
									<input type="hidden" id="id_cityOld" value="${venueInputType.value }" />
									<select  name="${venueInputType.fieldName }" id="id_citySelect">
										<option value=''>请选择市</option>
									</select>
								</span>
							</div>
						</div>
					</c:when>
					<c:otherwise>
						<c:choose>
							<c:when test="${venueInputType.fieldType eq 'SELECT' }">
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label>${venueInputType.itemName }：</label>
									</div>
									<div class="tatr-right">
										<span> 
										<select class="weui_select" name="${venueInputType.fieldName }" id="${venueInputType.fieldName }" title="${venueInputType.itemName }">
												<option value="">--请选择--</option>
												<c:forEach items="${venueInputType.options.split(',') }" var="option">
													<option value="${option }" ${venueInputType.value eq option ? "selected=selected":"" }>${option }</option>
												</c:forEach>
										</select>
										</span>
									</div>
								</div>
							</c:when>
							<c:when test="${venueInputType.fieldType eq 'TEXTAREA' }">
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label>${venueInputType.itemName }：</label>
									</div>
									<div class="tatr-right">
										<div class="pos-rel">
											<textarea name="${venueInputType.fieldName }" placeholder="${venueInputType.placeholder }"
												rows="10" maxlength="${venueInputType.maxLength }"
												oninput="textAreaInput(this,'${venueStatus.index}')" class="mt0">${venueInputType.value }</textarea>
										</div>
									</div>
								</div>
							</c:when>
							<c:when test="${venueInputType.fieldType eq 'CHECKBOX' }">
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label>${venueInputType.itemName }：</label>
									</div>
									<div class="tatr-right">
										<ul class="inche-war">
											<c:forEach items="${venueInputType.options.split(',') }" var="option" varStatus="status">
												<li>
													<span class="check-box"> <input type="checkbox" value="${option }"
															name="${venueInputType.fieldName }" id="${venueInputType.fieldName }${status.index}"
															<c:if test="${not empty venueInputType.value }">
											                <c:forEach items="${venueInputType.value.split(',') }" var="venueValue">
											                	${venueValue eq option ? "checked='checked'":"" }
											                </c:forEach>
											                </c:if>>
											                <label for="${venueInputType.fieldName }${status.index}"></label>
													</span>
													<span><label for="${venueInputType.fieldName }${status.index}">${option }</label></span>
												</li>
											</c:forEach>
										</ul>
									</div>
								</div>
							</c:when>
							<c:when test="${venueInputType.fieldType eq 'RADIO' }">
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label>${venueInputType.itemName }：</label>
									</div>
									<div class="tatr-right">
										<ul class="inche-war">
											<c:forEach items="${venueInputType.options.split(',') }" var="option" varStatus="status">
												<li><span>
												<input value="${option }" name="${venueInputType.fieldName }" id="${venueInputType.fieldName }${status.index}" type="radio"
												<c:if test="${not empty venueInputType.value }">
								                <c:forEach items="${venueInputType.value.split(',') }" var="venueValue">${venueValue eq option ? "checked='checked'":"" }</c:forEach></c:if>>
								                </span><span>${option }</span></li>
											</c:forEach>
										</ul>
									</div>
								</div>
							</c:when>
							<c:when test="${venueInputType.fieldType eq 'IMAGE' }">
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label>${venueInputType.itemName }：</label>
									</div>
									<div class="tatr-right">
										<div class="addimg-war clearfix">
											<ul style="margin-bottom: 0;">
												<li id="showImg${venueInputType.fieldName }"
													<c:if test="${empty venueInputType.value }"> style="display: none;"</c:if>>
													<p><img onclick="preViewImg(this);" src="${venueInputType.value }" class="pic"></p>
													<span onclick="removeImg('${venueInputType.fieldName }');"><img src="<c:url value='/resources/wechat2/images/picture-close.png'/>" class="closePic" /></span>
												</li>
												<li id="bt${venueInputType.fieldName }"
													<c:if test="${not empty venueInputType.value }"> style="display: none;"</c:if>>
													<p><img src="<c:url value='/resources/wechat2/images/add-picture.png'/>" class="pic"onclick="chooseImage('${venueInputType.fieldName }');"></p>
												</li>
											</ul>
											<input type="hidden" name="${venueInputType.fieldName }" id="${venueInputType.fieldName }">
										</div>
									</div>
								</div>
							</c:when>
							<c:otherwise>
								<div class="task-transfer clearfix">
									<div class="tatr-left">
										<label><c:if test="${venueInputType.required }"><strong>*</strong></c:if>${venueInputType.itemName } :</label>
									</div>
									<div class="tatr-right">
										<span> 
											<c:if test="${venueInputType.fieldType eq 'INPUT' }">
												<input class="${venueInputType.required ?'required':'' }" alt="${venueInputType.itemName }" value="${venueInputType.value }" placeholder="${venueInputType.placeholder }"
													maxlength="${venueInputType.maxLength }" type="text" name="${venueInputType.fieldName }" id="${venueInputType.fieldName }">
											</c:if> 
											<c:if test="${venueInputType.fieldType eq 'DATE' }">
												<input class="weui_input" name="${venueInputType.fieldName }" id="${venueInputType.fieldName }" value="${venueInputType.value }" readonly="readonly">
												<script>
													laydate({
														elem : '#${venueInputType.fieldName }',
														format : 'YYYY-MM-DD', // 分隔符可以任意定义，该例子表示只显示年月
														festival : false, //显示节日
														max : laydate.now(),
														choose : function(datas) {
															$("#${venueInputType.fieldName }")
																	.val(datas);
														}
													});
												</script>
											</c:if>
										</span>
									</div>
								</div>

							</c:otherwise>
						</c:choose>
					</c:otherwise>
				</c:choose>
			</c:forEach>
		</div>

		<div class="text-center submit-btn">
			<a href="javascript:submitForm();" class="btn btn-primary bg-2e9fe3">提交</a>
		</div>
	</form>
	<script>
		var baseUrl = '${pageContext.request.contextPath }';

		function textAreaInput(obj, index) {
			$("#remainNum" + index).html(obj.value.length);
		}
		getAllProvince();

		function getAllProvince() {
			$("#id_provSelect").empty();
			$("#id_provSelect").append("<option value=''>" + "请选择省份" + "</option>");
			//获取省份
			var url = baseUrl + "/public/provinceList";
			$.ajax({
				type : "post",
				url : url,
				async : false,
				dataType : "json",
				success : function(json) {
					if (json != null && json.length != 0) {
						for (var i = 0; i < json.length; i++) {
							$("#id_provSelect").append(
									"<option value='"+json[i].key+"'>" + json[i].value
											+ "</option>");
						}
					}
				}
			})
		};


        wx.config({
            debug : false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
            appId : '${appid}', // 必填，公众号的唯一标识
            timestamp : '${timestamp}', // 必填，生成签名的时间戳
            nonceStr : '${noncestr}', // 必填，生成签名的随机串
            signature : '${sign}',// 必填，签名，见附录1
            jsApiList : [ 'closeWindow', 'chooseImage', 'previewImage', 'uploadImage' ]
            // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
        });

        wx.ready(function() {
            //判断当前客户端版本是否支持指定JS接口
            wx.checkJsApi({
                jsApiList : [ 'chooseImage' ], // 需要检测的JS接口列表，所有JS接口列表见附录2,
                success : function(res) {
                    // 以键值对的形式返回，可用的api值true，不可用为false
                    // 如：{"checkResult":{"chooseImage":true},"errMsg":"checkJsApi:ok"}
                }
            });
            //隐藏右上角菜单接口
            wx.hideOptionMenu();

        });

		//拍照或从手机相册中选图接口
		function chooseImage(fieldName) {
			wx.chooseImage({
				count : 1, // 默认9
				sizeType : [ 'original', 'compressed' ], // 可以指定是原图还是压缩图，默认二者都有
				sourceType : [ 'album', 'camera' ], // 可以指定来源是相册还是相机，默认二者都有
				success : function(res) {
					var localIds = res.localIds; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
					if (localIds.length > 0) {
						uploadWXImage(localIds[0], fieldName);
					}
				}
			});
		}
		//微信上传图片
		function uploadWXImage(localId, fieldName) {
			wx.uploadImage({
				localId : localId, // 需要上传的图片的本地ID，由chooseImage接口获得
				isShowProgressTips : 1, // 默认为1，显示进度提示
				success : function(res) {
					var serverId = res.serverId; // 返回图片的服务器端ID
//                    if(window.__wxjs_is_wkwebview){
//                        localId = res.localData;
//                        localId = localId.replace('jgp', 'jpeg');
//					}

					$("#" + fieldName).val(serverId);
                    var showImg = "<p><img onclick='preViewImg(this);' src='" + localId + "' class='pic'></p>";
                    showImg = showImg + "<span onclick=\"removeImg('" + fieldName + "');\"><img src=\""+baseUrl+"/resources/wechat2/images/picture-close.png\" class='closePic'/></span>";

                    $("#showImg" + fieldName).html(showImg);
                    $("#showImg" + fieldName).show();
                    $("#bt" + fieldName).hide();
				}
			});
		}

		//预览图片
		function preViewImg(obj) {
			var imgUrl = obj.src;
			wx.previewImage({
				current : imgUrl, // 当前显示图片的http链接
				urls : [ imgUrl ]
			// 需要预览的图片http链接列表
			});
		}

		function removeImg(fieldName) {
			$("#" + fieldName).val("");
			$("#showImg" + fieldName).hide();
			$("#bt" + fieldName).show();
		}

		function submitForm() {
			var id_provSelect = $("#id_provSelect").val();
			if (id_provSelect == "") {
				layer.msg("请选择所在省份");
				window.location.hash = "id_provSelect";
				return;
			}
			var city = $("#id_citySelect").val();
			if (city == "") {
				layer.msg("请选择所在城市");
				window.location.hash = "id_citySelect";
				return;
			}
			var flag = true;
			$(".required").each(function(a, b) {
				if ($(b).val() == "") {
					layer.msg("请输入" + $(b).attr("alt"));
					window.location.hash = b.id;
					flag = false;
					return flag;
				}
			});
			if (flag) {
				$("select").each(function(a, b) {
					if ($(b).val() == "") {
						layer.msg("请选择" + $(b).attr("title"));
						window.location.hash = b.id;
						flag = false;
						return flag;
					}
				});
			}

			if (!flag)
				return;

			var loadIndex = layer.load(0, {
				shade : [ 0.3, '#808080' ]
			});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/wechat/venue/saveVenue.json",
				data : $("#venueForm").serialize(),
				dataType : "json",
				//async :false,
				success : function(data) {
					layer.close(loadIndex);
					layer.msg(data.msg);
					if (data.successful)
						setTimeout("gotoVenueList()", 2000);

				},
				error : function() {
					layer.close(loadIndex);
					alert('error');
				}
			});
		}

		function gotoVenueList() {
			window.location.assign(baseUrl + "/wechat/venue/venueList/init");
		}

		function autoSave() {
			$.ajax({
				type : 'POST',
				url : baseUrl + "/wechat/venue/saveVenue.json",
				data : $("#venueForm").serialize(),
				dataType : "json",
				//async :false,
				success : function(data) {
				    if(data.successful){
                        $("#venueId").val(data.data);
                        layer.msg("自动保存成功!");
					}
				},
				error : function() {
					alert('error');
				}
			});
		}

		$(function() {
			initProvinceRegion();
			var proOld = $("#id_provOld").val();
			$("#id_provSelect").val(proOld);
			$("#id_provSelect").trigger("change");
			var cityOld = $("#id_cityOld").val();
			$("#id_citySelect").val(cityOld);

			var saveTimer = setInterval(function() {
				autoSave();
			}, 60000); //每分钟保存一次
		})
		
		
    
	function initProvinceRegion(){
        $.ajax({
            type: 'POST',
            url: baseUrl + "/public/provinceList.json",
            async: false,
            success: function(data){
            	$("#id_provSelect").empty();
        		$("#id_provSelect").append("<option value=''>" + "请选择省份" + "</option>");
                for(var i=0;i <data.length;i++){
                    $("#id_provSelect").append("<option value='"+data[i].oid+"'>"+data[i].province+"</option>");
                }
            },
            error:function (XMLHttpRequest, textStatus, errorThrown){
                alert('请求失败');
            }
        });
    }

    function initCityRegion(){
    	$("#id_citySelect").empty();
		$("#id_citySelect").append("<option value=''>" + "请选择城市" + "</option>");
        var province = $("#id_provSelect").val();
        $.ajax({
            type: 'POST',
            url: baseUrl + "/public/getRegionByParent.json",
            data:{'parentId':province},
            async: false,
            success: function(data){
                for(var i=0;i <data.length;i++){
                    $("#id_citySelect").append("<option value='"+data[i].oid+"'>"+data[i].city+"</option>");
                }

            },
            error:function (XMLHttpRequest, textStatus, errorThrown){
                alert('请求失败');
            }
        });
    }
	</script>