<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<c:if test="${not empty taskList }">
	<c:forEach items="${taskList }" var="surveyTask">
		<tr>
			<td>${surveyTask.name }</td>
			<td><fmt:formatDate value='${surveyTask.activityTime }' pattern='yyyy-MM-dd HH:mm' /><br>-<br><fmt:formatDate value='${surveyTask.endTime }' pattern='yyyy-MM-dd HH:mm' /></td>
			<td>${surveyTask.address }&nbsp;</td>
			<td>${surveyTask.contacts }<br />${surveyTask.contactMobile }</td>
			<td>${surveyTask.surveyTaskStatus.name }</td>
			<td>
				<c:if test="${surveyTask.surveyTaskStatus eq 'RECEIVE' || surveyTask.surveyTaskStatus eq 'DOING'}">
					<a href="javascript:createQuestion('${surveyTask.oid }');">问卷设计</a>
				</c:if>
				<c:if test="${surveyTask.surveyTaskStatus eq 'OBSOLETE' }">
					<a href="javascript:createQuestion('${surveyTask.oid }');">查看详情</a>
				</c:if>
			</td>
		</tr>
	</c:forEach>
</c:if>
<c:if test="${empty taskList }">
	<tr>
		<td colspan="6" class="text-center">无相关数据</td>
	</tr>
</c:if>
