<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>计划列表</title>
	<%@ include file="/WEB-INF/views/include/wechatHead.jsp"%>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/wechat/surveyPlan.js?v=${version}'/>"></script>
	<script type="text/javascript" src="<c:url value='/resources/js/d_modal/d_modal.js?v=${version}'/>"></script>
</head>
<body>
	<div style="display:flex; height:50px; line-height:50px;background:#FFF;border-bottom:1px solid #DDD;"  onclick="javascript:history.back();">
		<div style="width:5%;font-size:18px; padding-left:15px;">   <   </div>
		<div style="width:95%; text-align:center; text-indent:-10px; font-size:18px;">   计划列表   </div>
	</div>
	<div class="tab-content nmt10"> 
		  	<table class="table"> 
			  <thead>
			    <tr>
			      	<th>活动名称</th>
			      	<th>活动时间</th>
			      	<th>活动地点</th>
			      	<th>联系人</th>
					<th>勘查专家</th>
			      	<th>状态</th>
			      	<th>操作</th>
			    </tr>
			  </thead>
			  <tbody>
			    <tr>
			      <td><input name="taskId" id="surveyTaskId" value="${task.oid }" type="hidden">${task.name }</td>
			      <td><fmt:formatDate value='${task.activityTime }' pattern='yyyy-MM-dd HH:mm' /><br>-<br><fmt:formatDate value='${task.endTime }' pattern='yyyy-MM-dd HH:mm' /></td>
			      <td>${task.address }&nbsp;</td>
			      <td>${task.contacts }<br />${task.contactMobile }</td>
					<td>
						<c:if test="${not empty expertName}">
							<c:if test="${not empty expertName}">
								<c:set value="${fn:split(expertName,',')}" var="experts" />
								<c:forEach items="${experts}" var="item">
									${item}<br/>
								</c:forEach>
							</c:if>
						</c:if>
						<c:if test="${ empty expertName}">
							--
						</c:if>
					</td>
			      <td>${task.surveyTaskStatus.name }&nbsp;</td>
			      <td>
			      <c:if test="${task.surveyTaskStatus eq 'DOING' }">
			      	<a href="#" id="receiveBtn">新增计划</a>
			      </c:if>
			      </td>
			    </tr> 
			  </tbody>
			</table>
		  </div> 
		  
		  <div class="clear"></div>
		  <div class="tab-content nmt-10"> 
		  	<table class="table"> 
			  <thead class="bg-ececec">
			    <tr>
			      	<th>勘查次数</th>
			      	<th>勘查阶段</th>
			      	<th>勘查时间</th>
					<th>勘查专家</th>
			      	<th>勘查场地</th>
			      	<th>状态</th>
			      	<th>操作</th>
			    </tr>
			  </thead>
			  <tbody class="plan-war">
				<c:forEach items="${planList }" var="plan">
			    <tr>
			      	<td>第${plan.time }次勘查</td>
			      	<td>第${plan.surveyStep}阶段勘查</td>
			      	<td>
						${plan.beginTime }<br/>
					 	 -<br/>
						${plan.endTime }
				  	</td>
					<td>
						<c:if test="${not empty plan.tkExpert}">
							<c:if test="${not empty plan.tkExpert}">
								<c:set value="${fn:split(plan.tkExpert,',')}" var="experts" />
								<c:forEach items="${experts}" var="item">
									${item}<br/>
								</c:forEach>
							</c:if>
						</c:if>
						<c:if test="${ empty plan.tkExpert}">
							--
						</c:if>
					</td>
			      	<td>${plan.venueName }&nbsp;</td>
			      	<td class="${plan.taskStatus eq 'COMPLETE' || plan.taskStatus eq 'CLOSE' ? 'c-49a61a':'c-f98718'}">
			      	${plan.taskStatusName }
			      	</td>
			      	<td>
			      	<c:if test="${task.surveyTaskStatus eq 'DOING' }">
			      	<c:choose>
						<c:when test="${plan.taskStatus eq 'COMPLETE' || plan.taskStatus eq 'CLOSE'}">
						</c:when>
						<c:otherwise>
						<a href="#" class="updatePlan" id="${plan.oid }">修改</a> 
						<a href="javascript:deletePlan('${plan.oid }');">删除</a> 
						<c:if test="${plan.feedBack.experts.size()>0}">
							<a href="javascript:showExperts('${plan.oid }');">查看专家</a> 
						</c:if>
						</c:otherwise>
					</c:choose>
					</c:if>
			      </td>
			    </tr> 
			    </c:forEach>
			  </tbody>
			</table>
			<div class="container">
				<div class="text-center plan-btn">
					<c:if test="${task.surveyTaskStatus eq 'DOING' }">
						<c:if test="${expertSource ne 'public'}">
							<a href="javascript:transferTask('${task.oid }');" class="btn btn-primary bg-2e9fe3">任务转交</a>
						</c:if>
						<%--<c:if test="${showExpertBtn eq 'true'}">
							<a href="javascript:applyExpert('${task.oid }');" class="btn btn-primary bg-2e9fe3">专家申请</a>
						</c:if>--%>
					</c:if>
					<a href="javascript:goBack();" class="btn btn-primary bg-2e9fe3">返回</a>
				</div>
			</div>
		  </div> 
</body>

<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	var plansize = '${planList.size()}';
	
	 $('#receiveBtn').on('click',function(){
		var surveyTaskId = $("#surveyTaskId").val();
		$("body").addClass("unoverflow");
        $("#modal").remove();
    	$(this).d_modal({
            title: '新增计划',
            cssclass:'modal-blue modal-mid',
            content: "loading....",
            cache:false,
            remote: baseUrl + '/wechat/plan/addPlan/init?taskId='+surveyTaskId
        });
    });
	
	 $('.updatePlan').on('click',function(){
		var planId = this.id;
		$("body").addClass("unoverflow");
        $("#modal").remove();
    	$(this).d_modal({
            title: '修改计划',
            cssclass:'modal-blue modal-mid',
            content: "loading....",
            cache:false,
            remote: baseUrl + "/wechat/plan/editPlan/init/"+planId
        });
    });
	 
	function showExperts(planId){
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({			
			type : 'POST',
			url : baseUrl + "/wechat/plan/getExpertsByPlanId.json",
			data :{"planId":planId},
			dataType : "json",
			//async :false,
			success : function(data) {
				layer.close(loadIndex);
				if(data.status == "200"){
					var infos="";
					infos = "<div style=\"text-align: center;margin:10px 20px;\">";
					for(var i=0; i< data.experts.length;i++){
						var expert = data.experts[i];
						infos= infos + "<p style=\"margin:10px 20px;\">"+(i+1) +"、" + "专家名字：" +expert.name + ",&nbsp;&nbsp;联系方式：" + expert.mobile+"</p>";
					}
					infos = infos + "</div>";
					
					parent.layer.open({
						type : 1,
						content : infos,
						title : "专家详情",
						btn : [ '确定' ], //按钮
						yes : function() {
							parent.layer.closeAll();
						}
					});
				}
			},
			error : function() {
				layer.close(loadIndex);
				layer.msg('系统发生未知错误，请联系管理员确认');
			}
		});
	}
	
	
	function goBack() {
		window.location.assign(baseUrl + "/wechat/task/taskList/init");
	}

	function transferTask(taskId) {
		window.location.assign(baseUrl + "/wechat/task/transferTask/init?taskId=" + taskId);
	}

	function applyExpert(taskId) {
		window.location.assign(baseUrl + "/wechat/task/applyExpert/init?taskId=" + taskId);
	}
</script>
</html>

