package com.bcxin.survey.utils;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.activity.Message;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.report.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


/**
 * @author 张建华
 * @date 2018/8/22
 */
@Service
public class SurveyManagerUtil {


    @Autowired
    private ActivityService activityService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private UserService userService;

    @Autowired
    private BaseDao baseDao;

    /**
     * 返回机构踏勘经理和区域经理列表
     *
     * @param surveyTask
     * @return
     * @Author zjh
     */
    public List<User> listSurveyManger(SurveyTask surveyTask) {

        if (surveyTask != null) {
            List<Activity> activityList = activityService.selectActivityBySurveyTaskId(surveyTask.getOid());

            if (activityList != null) {
                Activity activity = activityList.get(0);
                if (activity != null) {
                    User user = userService.getCurrentUser();
                    if (user != null) {
                        List<User> listTKManager = userService.listTKManager(user.getOid());
                        return listTKManager;
                    }
                }
            }
        }
        return null;
    }

    public Task selectTaskBySurveyTask(SurveyTask surveyTask) {

        List<Task> taskList = taskService.selectTaskBysurveryTaskId(surveyTask.getOid());
        if (CollectionUtil.isNotEmpty(taskList)) {
            return taskList.get(0);
        }
        return null;
    }

    /**
     * 根据踏勘任务，查询活动信息
     *
     * @param surveyTask
     * @return
     */
    public Activity selectActivity(SurveyTask surveyTask) {
        List<Activity> activityList = activityService.selectActivityBySurveyTaskId(surveyTask.getOid());
        if (CollectionUtil.isNotEmpty(activityList)) {
            return activityList.get(0);
        }
        return null;
    }

    /**
     * 根据踏勘任务信息，向区域经理和勘查经理发送站内信
     *
     * @param surveyTask
     */
    public void saveMessage(SurveyTask surveyTask, Message message) {

        if (surveyTask != null) {
            User user = userService.getCurrentUser();
            if (user != null) {
                List<User> listTKManager = userService.listTKManager(user.getOid());
                if (listTKManager != null) {
                    Date date = new Date();
                    for (User manager : listTKManager) {
                        Message message1 = new Message();
                        message1.setReadStatus("0");
                        message1.setCreateOn(date);
                        message1.setUser_id(manager.getOid());
                        message1.setContent(message.getContent());
                        message1.setKeyword(message.getKeyword());
                        message1.setUrl(message.getUrl());
                        message1.setTitle(message.getTitle());
                        baseDao.saveOrUpdate(message1);
                    }
                }
            }
        }
    }
}